/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.SimpleEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ColumnEvaluator
extends SimpleEvaluator
implements Expressible {
    private static final long serialVersionUID = 1L;
    private String name;
    private String fieldName;

    public ColumnEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        String name = factory.getValueOperand(expression, 0);
        String fieldName = factory.getValueOperand(expression, 1);
        this.init(name, fieldName);
    }

    private void init(String name, String fieldName) {
        this.name = name;
        this.fieldName = fieldName;
    }

    @Override
    public List<Number> evaluate(Tuple tuple) throws IOException {
        List tuples = (List)tuple.get(this.name);
        ArrayList<Number> column = new ArrayList<Number>(tuples.size());
        for (Tuple t : tuples) {
            Object o = t.get(this.fieldName);
            if (o instanceof Number) {
                column.add((Number)o);
                continue;
            }
            throw new IOException("Found non-numeric in column:" + o.toString());
        }
        return column;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }
}

