/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.github.tomakehurst.wiremock.http.Request;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.net.URI;

public class UniqueFilenameGenerator {
    public static String generate(Request request, String prefix, String id) {
        return UniqueFilenameGenerator.generate(request, prefix, id, "json");
    }

    public static String generate(Request request, String prefix, String id, String extension) {
        URI uri = URI.create(request.getUrl());
        Iterable uriPathNodes = Splitter.on((String)"/").omitEmptyStrings().split((CharSequence)uri.getPath());
        int nodeCount = Iterables.size((Iterable)uriPathNodes);
        String pathPart = nodeCount > 0 ? UniqueFilenameGenerator.sanitise(Joiner.on((String)"-").join((Iterable)FluentIterable.from((Iterable)uriPathNodes).skip(nodeCount - Math.min(nodeCount, 2)))) : "(root)";
        return prefix + "-" + pathPart + "-" + id + "." + extension;
    }

    private static String sanitise(String input) {
        return input.replaceAll("[,~:/?#\\[\\]@!\\$&'()*+;=]", "_");
    }
}

