/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.nio.charset.Charset;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;

public abstract class AbstractCsvLayout
extends AbstractStringLayout {
    protected static final String DEFAULT_CHARSET = "UTF-8";
    protected static final String DEFAULT_FORMAT = "Default";
    private static final String CONTENT_TYPE = "text/csv";
    private static final long serialVersionUID = 1L;
    private final CSVFormat format;

    protected AbstractCsvLayout(Charset charset, CSVFormat csvFormat, String header, String footer) {
        super(charset, AbstractCsvLayout.toBytes(header, charset), AbstractCsvLayout.toBytes(footer, charset));
        this.format = csvFormat;
    }

    protected static CSVFormat createFormat(String format, Character delimiter, Character escape, Character quote, QuoteMode quoteMode, String nullString, String recordSeparator) {
        CSVFormat csvFormat = CSVFormat.valueOf((String)format);
        if (delimiter != null) {
            csvFormat = csvFormat.withDelimiter(delimiter.charValue());
        }
        if (escape != null) {
            csvFormat = csvFormat.withEscape(escape);
        }
        if (quote != null) {
            csvFormat = csvFormat.withQuote(quote);
        }
        if (quoteMode != null) {
            csvFormat = csvFormat.withQuoteMode(quoteMode);
        }
        if (nullString != null) {
            csvFormat = csvFormat.withNullString(nullString);
        }
        if (recordSeparator != null) {
            csvFormat = csvFormat.withRecordSeparator(recordSeparator);
        }
        return csvFormat;
    }

    @Override
    public String getContentType() {
        return "text/csv; charset=" + this.getCharset();
    }

    public CSVFormat getFormat() {
        return this.format;
    }
}

