/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.io.wkt.AbstractParser;
import org.apache.sis.io.wkt.Element;
import org.apache.sis.io.wkt.Symbols;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Numbers;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

class MathTransformParser
extends AbstractParser {
    static final String[] ID_KEYWORDS = new String[]{"Id", "Authority"};
    private static final String[] UNIT_KEYWORDS = new String[]{"Unit", "LengthUnit", "AngleUnit", "ScaleUnit", "TimeUnit", "ParametricUnit"};
    private static final Unit<?>[] BASE_UNITS = new Unit[]{SI.METRE, SI.RADIAN, Unit.ONE, SI.SECOND};
    final MathTransformFactory mtFactory;
    private transient String classification;
    private transient OperationMethod lastMethod;

    public MathTransformParser(MathTransformFactory mathTransformFactory) {
        this(Symbols.getDefault(), Collections.emptyMap(), null, null, null, mathTransformFactory, null);
    }

    MathTransformParser(Symbols symbols, Map<String, Element> map, NumberFormat numberFormat, DateFormat dateFormat, UnitFormat unitFormat, MathTransformFactory mathTransformFactory, Locale locale) {
        super(symbols, map, numberFormat, dateFormat, unitFormat, locale);
        this.mtFactory = mathTransformFactory;
        ArgumentChecks.ensureNonNull("mtFactory", mathTransformFactory);
    }

    @Override
    String getPublicFacade() {
        return "org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory";
    }

    @Override
    Object parseObject(Element element) throws ParseException {
        return this.parseMathTransform(element, true);
    }

    final MathTransform parseMathTransform(Element element, boolean bl) throws ParseException {
        this.lastMethod = null;
        this.classification = null;
        MathTransform mathTransform = this.parseParamMT(element);
        if (mathTransform == null && (mathTransform = this.parseConcatMT(element)) == null && (mathTransform = this.parseInverseMT(element)) == null && (mathTransform = this.parsePassThroughMT(element)) == null && bl) {
            throw element.missingOrUnknownComponent("Param_MT");
        }
        return mathTransform;
    }

    final Unit<?> parseUnitID(Element element) throws ParseException {
        Element element2 = element.pullElement(1, ID_KEYWORDS);
        if (element2 != null) {
            String string = element2.pullString("codeSpace");
            Object object = element2.pullObject("code");
            element2.close(this.ignoredElements);
            if ("EPSG".equalsIgnoreCase(string)) {
                try {
                    int n = Numbers.isInteger(object.getClass()) ? ((Number)object).intValue() : Integer.parseInt(object.toString());
                    return Units.valueOfEPSG(n);
                }
                catch (NumberFormatException numberFormatException) {
                    this.warning(element, element2, numberFormatException);
                }
            }
        }
        return null;
    }

    final Unit<?> parseUnit(Element element) throws ParseException {
        Element element2 = element.pullElement(1, UNIT_KEYWORDS);
        if (element2 == null) {
            return null;
        }
        String string = element2.pullString("name");
        double d = element2.pullDouble("factor");
        int n = element2.getKeywordIndex() - 1;
        Unit<?> unit = this.parseUnitID(element2);
        element2.close(this.ignoredElements);
        if (unit != null) {
            return unit;
        }
        if (n >= 0 && n < BASE_UNITS.length) {
            return Units.multiply(BASE_UNITS[n], d);
        }
        return this.parseUnit(string);
    }

    final void parseParameters(Element element, ParameterValueGroup parameterValueGroup, Unit<?> unit, Unit<Angle> unit2) throws ParseException {
        Unit<?> unit3 = unit != null ? unit.toSI() : null;
        Element element2 = element;
        try {
            while ((element2 = element.pullElement(1, "Parameter")) != null) {
                String string = element2.pullString("name");
                Unit<Object> unit4 = this.parseUnit(element2);
                element2.pullElement(1, ID_KEYWORDS);
                ParameterValue<?> parameterValue = parameterValueGroup.parameter(string);
                ParameterDescriptor<?> parameterDescriptor = parameterValue.getDescriptor();
                Class<?> clazz = parameterDescriptor.getValueClass();
                boolean bl = Number.class.isAssignableFrom(clazz);
                if (bl && unit4 == null && (unit4 = parameterDescriptor.getUnit()) != null) {
                    Unit<?> unit5 = unit4.toSI();
                    if (unit5.equals(unit3)) {
                        unit4 = unit;
                    } else if (unit5.equals(SI.RADIAN)) {
                        unit4 = unit2;
                    }
                }
                if (unit4 != null) {
                    parameterValue.setValue(element2.pullDouble("doubleValue"), unit4);
                } else if (bl) {
                    if (Numbers.isInteger(clazz)) {
                        parameterValue.setValue(element2.pullInteger("intValue"));
                    } else {
                        parameterValue.setValue(element2.pullDouble("doubleValue"));
                    }
                } else if (clazz == Boolean.class) {
                    parameterValue.setValue(element2.pullBoolean("booleanValue"));
                } else {
                    parameterValue.setValue(element2.pullString("stringValue"));
                }
                element2.close(this.ignoredElements);
            }
        }
        catch (ParameterNotFoundException parameterNotFoundException) {
            throw (ParseException)new LocalizedParseException(this.errorLocale, 152, new String[]{parameterNotFoundException.getParameterName()}, element2.offset).initCause(parameterNotFoundException);
        }
        catch (InvalidParameterValueException invalidParameterValueException) {
            throw (ParseException)new ParseException(invalidParameterValueException.getLocalizedMessage(), element2.offset).initCause(invalidParameterValueException);
        }
    }

    private MathTransform parseParamMT(Element element) throws ParseException {
        MathTransform mathTransform;
        ParameterValueGroup parameterValueGroup;
        Element element2 = element.pullElement(0, "Param_MT");
        if (element2 == null) {
            return null;
        }
        this.classification = element2.pullString("classification");
        try {
            parameterValueGroup = this.mtFactory.getDefaultParameters(this.classification);
        }
        catch (NoSuchIdentifierException noSuchIdentifierException) {
            throw element2.parseFailed(noSuchIdentifierException);
        }
        this.parseParameters(element2, parameterValueGroup, null, null);
        element2.close(this.ignoredElements);
        try {
            mathTransform = this.mtFactory.createParameterizedTransform(parameterValueGroup);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
        this.lastMethod = this.mtFactory.getLastMethodUsed();
        return mathTransform;
    }

    private MathTransform parseInverseMT(Element element) throws ParseException {
        Element element2 = element.pullElement(0, "Inverse_MT");
        if (element2 == null) {
            return null;
        }
        MathTransform mathTransform = this.parseMathTransform(element2, true);
        try {
            mathTransform = mathTransform.inverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw element2.parseFailed(noninvertibleTransformException);
        }
        element2.close(this.ignoredElements);
        return mathTransform;
    }

    private MathTransform parsePassThroughMT(Element element) throws ParseException {
        Element element2 = element.pullElement(0, "PassThrough_MT");
        if (element2 == null) {
            return null;
        }
        int n = element.pullInteger("firstAffectedOrdinate");
        MathTransform mathTransform = this.parseMathTransform(element2, true);
        element2.close(this.ignoredElements);
        try {
            return this.mtFactory.createPassThroughTransform(n, mathTransform, 0);
        }
        catch (FactoryException factoryException) {
            throw element2.parseFailed(factoryException);
        }
    }

    private MathTransform parseConcatMT(Element element) throws ParseException {
        MathTransform mathTransform;
        Element element2 = element.pullElement(0, "Concat_MT");
        if (element2 == null) {
            return null;
        }
        MathTransform mathTransform2 = this.parseMathTransform(element2, true);
        while ((mathTransform = this.parseMathTransform(element2, false)) != null) {
            try {
                mathTransform2 = this.mtFactory.createConcatenatedTransform(mathTransform2, mathTransform);
            }
            catch (FactoryException factoryException) {
                throw element2.parseFailed(factoryException);
            }
        }
        element2.close(this.ignoredElements);
        return mathTransform2;
    }

    final OperationMethod getOperationMethod() {
        if (this.lastMethod == null && this.classification != null) {
            this.lastMethod = ReferencingServices.getInstance().getOperationMethod(this.mtFactory.getAvailableMethods(SingleOperation.class), this.classification);
        }
        return this.lastMethod;
    }
}

