/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.MergedProperties;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Utilities;
import org.apache.sis.referencing.operation.AbstractSingleOperation;
import org.apache.sis.referencing.operation.DefaultConcatenatedOperation;
import org.apache.sis.referencing.operation.DefaultConicProjection;
import org.apache.sis.referencing.operation.DefaultConversion;
import org.apache.sis.referencing.operation.DefaultCylindricalProjection;
import org.apache.sis.referencing.operation.DefaultOperationMethod;
import org.apache.sis.referencing.operation.DefaultPlanarProjection;
import org.apache.sis.referencing.operation.DefaultProjection;
import org.apache.sis.referencing.operation.DefaultTransformation;
import org.apache.sis.referencing.operation.OperationPathFinder;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.PlanarProjection;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

public class DefaultCoordinateOperationFactory
extends AbstractFactory
implements CoordinateOperationFactory {
    private final Map<String, ?> defaultProperties;
    private volatile MathTransformFactory mtFactory;
    private final WeakHashSet<IdentifiedObject> pool;
    private transient CoordinateOperationFactory delegate;

    public DefaultCoordinateOperationFactory() {
        this.defaultProperties = Collections.emptyMap();
        this.pool = new WeakHashSet<IdentifiedObject>(IdentifiedObject.class);
    }

    public DefaultCoordinateOperationFactory(Map<String, ?> map, MathTransformFactory mathTransformFactory) {
        map = map == null || map.isEmpty() ? Collections.emptyMap() : CollectionsExt.compact(new HashMap(map));
        this.defaultProperties = map;
        this.mtFactory = mathTransformFactory;
        this.pool = new WeakHashSet<IdentifiedObject>(IdentifiedObject.class);
    }

    protected Map<String, ?> complete(Map<String, ?> map) {
        ArgumentChecks.ensureNonNull("properties", map);
        return new MergedProperties(map, this.defaultProperties);
    }

    private MathTransformFactory getMathTransformFactory() {
        MathTransformFactory mathTransformFactory = this.mtFactory;
        if (mathTransformFactory == null) {
            this.mtFactory = mathTransformFactory = DefaultFactories.forBuildin(MathTransformFactory.class);
        }
        return mathTransformFactory;
    }

    public OperationMethod getOperationMethod(String string) throws FactoryException {
        MathTransformFactory mathTransformFactory = this.getMathTransformFactory();
        if (mathTransformFactory instanceof DefaultMathTransformFactory) {
            return ((DefaultMathTransformFactory)mathTransformFactory).getOperationMethod(string);
        }
        string = CharSequences.trimWhitespaces(string);
        ArgumentChecks.ensureNonEmpty("name", string);
        OperationMethod operationMethod = ReferencingServices.getInstance().getOperationMethod(mathTransformFactory.getAvailableMethods(SingleOperation.class), string);
        if (operationMethod != null) {
            return operationMethod;
        }
        throw new NoSuchIdentifierException(Errors.getResources(this.defaultProperties).getString((short)179, string), string);
    }

    public OperationMethod createOperationMethod(Map<String, ?> map, Integer n, Integer n2, ParameterDescriptorGroup parameterDescriptorGroup) throws FactoryException {
        DefaultOperationMethod defaultOperationMethod;
        try {
            defaultOperationMethod = new DefaultOperationMethod(map, n, n2, parameterDescriptorGroup);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        return this.pool.unique(defaultOperationMethod);
    }

    @Override
    public Conversion createDefiningConversion(Map<String, ?> map, OperationMethod operationMethod, ParameterValueGroup parameterValueGroup) throws FactoryException {
        DefaultConversion defaultConversion;
        try {
            defaultConversion = new DefaultConversion(map, operationMethod, null, parameterValueGroup);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        return defaultConversion;
    }

    public SingleOperation createSingleOperation(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateReferenceSystem coordinateReferenceSystem3, OperationMethod operationMethod, MathTransform mathTransform) throws FactoryException {
        Serializable serializable;
        Object object;
        ArgumentChecks.ensureNonNull("sourceCRS", coordinateReferenceSystem);
        ArgumentChecks.ensureNonNull("targetCRS", coordinateReferenceSystem2);
        ArgumentChecks.ensureNonNull("method", operationMethod);
        if (mathTransform == null) {
            object = Containers.property(map, "parameters", ParameterValueGroup.class);
            if (object == null) {
                throw new NullArgumentException(Errors.format((short)95, "transform"));
            }
            mathTransform = this.mtFactory.createBaseToDerived(coordinateReferenceSystem, (ParameterValueGroup)object, coordinateReferenceSystem2.getCoordinateSystem());
        }
        if ((object = Containers.property(map, "operationType", Class.class)) == null) {
            object = SingleOperation.class;
        }
        if (operationMethod instanceof DefaultOperationMethod && (serializable = ((DefaultOperationMethod)operationMethod).getOperationType()) != null) {
            if (((Class)object).isAssignableFrom((Class<?>)serializable)) {
                object = serializable;
            } else if (!serializable.isAssignableFrom((Class<?>)object)) {
                throw new IllegalArgumentException(Errors.format((short)45, "operationType"));
            }
        }
        if (object == SingleOperation.class) {
            object = OperationPathFinder.isConversion(coordinateReferenceSystem, coordinateReferenceSystem2) ? (coordinateReferenceSystem3 == null && coordinateReferenceSystem instanceof GeographicCRS && coordinateReferenceSystem2 instanceof ProjectedCRS ? Projection.class : Conversion.class) : Transformation.class;
        }
        if (Transformation.class.isAssignableFrom((Class<?>)object)) {
            serializable = new DefaultTransformation(map, coordinateReferenceSystem, coordinateReferenceSystem2, coordinateReferenceSystem3, operationMethod, mathTransform);
        } else if (Projection.class.isAssignableFrom((Class<?>)object)) {
            ArgumentChecks.ensureCanCast("sourceCRS", GeographicCRS.class, coordinateReferenceSystem);
            ArgumentChecks.ensureCanCast("targetCRS", ProjectedCRS.class, coordinateReferenceSystem2);
            if (coordinateReferenceSystem3 != null) {
                throw new IllegalArgumentException(Errors.format((short)26, "interpolationCRS", object));
            }
            GeographicCRS geographicCRS = (GeographicCRS)coordinateReferenceSystem;
            ProjectedCRS projectedCRS = (ProjectedCRS)coordinateReferenceSystem2;
            serializable = CylindricalProjection.class.isAssignableFrom((Class<?>)object) ? new DefaultCylindricalProjection(map, geographicCRS, projectedCRS, operationMethod, mathTransform) : (ConicProjection.class.isAssignableFrom((Class<?>)object) ? new DefaultConicProjection(map, geographicCRS, projectedCRS, operationMethod, mathTransform) : (PlanarProjection.class.isAssignableFrom((Class<?>)object) ? new DefaultPlanarProjection(map, geographicCRS, projectedCRS, operationMethod, mathTransform) : new DefaultProjection(map, geographicCRS, projectedCRS, operationMethod, mathTransform)));
        } else {
            serializable = Conversion.class.isAssignableFrom((Class<?>)object) ? new DefaultConversion(map, coordinateReferenceSystem, coordinateReferenceSystem2, coordinateReferenceSystem3, operationMethod, mathTransform) : new AbstractSingleOperation(map, coordinateReferenceSystem, coordinateReferenceSystem2, coordinateReferenceSystem3, operationMethod, mathTransform);
        }
        if (!((Class)object).isInstance(serializable)) {
            throw new FactoryException(Errors.format((short)5, object));
        }
        return (SingleOperation)((Object)this.pool.unique(serializable));
    }

    @Override
    public CoordinateOperation createConcatenatedOperation(Map<String, ?> map, CoordinateOperation ... coordinateOperationArray) throws FactoryException {
        DefaultConcatenatedOperation defaultConcatenatedOperation;
        try {
            defaultConcatenatedOperation = new DefaultConcatenatedOperation(map, coordinateOperationArray, this.getMathTransformFactory());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FactoryException(illegalArgumentException);
        }
        return this.pool.unique(defaultConcatenatedOperation);
    }

    @Override
    public CoordinateOperation createOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, OperationMethod operationMethod) throws FactoryException {
        return this.delegate().createOperation(coordinateReferenceSystem, coordinateReferenceSystem2, operationMethod);
    }

    @Override
    public CoordinateOperation createOperation(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) throws OperationNotFoundException, FactoryException {
        return this.delegate().createOperation(coordinateReferenceSystem, coordinateReferenceSystem2);
    }

    private synchronized CoordinateOperationFactory delegate() throws FactoryException {
        if (this.delegate != null) {
            return this.delegate;
        }
        for (CoordinateOperationFactory coordinateOperationFactory : ServiceLoader.load(CoordinateOperationFactory.class)) {
            if (Utilities.isSIS(coordinateOperationFactory.getClass())) continue;
            this.delegate = coordinateOperationFactory;
            return coordinateOperationFactory;
        }
        throw new FactoryException(Errors.format((short)61, "geotk-referencing"));
    }
}

