/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.referencing.Legacy;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.internal.referencing.provider.Affine;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultSpatialTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.DefaultDerivedCRS;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class ServicesForMetadata
extends ReferencingServices {
    private static String dimensionNotFound(short s, CoordinateReferenceSystem coordinateReferenceSystem) {
        if (coordinateReferenceSystem == null) {
            return Errors.format((short)173);
        }
        return Errors.format(s, coordinateReferenceSystem.getName());
    }

    private void setGeographicExtent(Envelope envelope, DefaultGeographicBoundingBox defaultGeographicBoundingBox, CoordinateReferenceSystem coordinateReferenceSystem, GeographicCRS geographicCRS) throws TransformException {
        if (geographicCRS != null) {
            CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
            EllipsoidalCS ellipsoidalCS = geographicCRS.getCoordinateSystem();
            if (!Utilities.equalsIgnoreMetadata(ellipsoidalCS.getAxis(0), coordinateSystem.getAxis(0)) || !Utilities.equalsIgnoreMetadata(ellipsoidalCS.getAxis(1), coordinateSystem.getAxis(1))) {
                CoordinateOperation coordinateOperation;
                CoordinateOperationFactory coordinateOperationFactory = DefaultFactories.forBuildin(CoordinateOperationFactory.class);
                try {
                    coordinateOperation = coordinateOperationFactory.createOperation(coordinateReferenceSystem, geographicCRS);
                }
                catch (FactoryException factoryException) {
                    throw new TransformException(Errors.format((short)174), factoryException);
                }
                envelope = Envelopes.transform(coordinateOperation, envelope);
            }
        }
        double d = envelope.getMinimum(0);
        double d2 = envelope.getMaximum(0);
        double d3 = envelope.getMinimum(1);
        double d4 = envelope.getMaximum(1);
        if (geographicCRS != null) {
            double d5 = CRS.getGreenwichLongitude(geographicCRS);
            d += d5;
            d2 += d5;
        }
        defaultGeographicBoundingBox.setBounds(d, d2, d3, d4);
        defaultGeographicBoundingBox.setInclusion(Boolean.TRUE);
    }

    private static void setVerticalExtent(Envelope envelope, DefaultVerticalExtent defaultVerticalExtent, CoordinateReferenceSystem coordinateReferenceSystem, VerticalCRS verticalCRS) {
        int n;
        if (verticalCRS == null) {
            n = 0;
        } else {
            n = AxisDirections.indexOfColinear(coordinateReferenceSystem.getCoordinateSystem(), verticalCRS.getCoordinateSystem());
            assert (n >= 0) : coordinateReferenceSystem;
        }
        defaultVerticalExtent.setMinimumValue(envelope.getMinimum(n));
        defaultVerticalExtent.setMaximumValue(envelope.getMaximum(n));
        defaultVerticalExtent.setVerticalCRS(verticalCRS);
    }

    private static void setTemporalExtent(Envelope envelope, DefaultTemporalExtent defaultTemporalExtent, CoordinateReferenceSystem coordinateReferenceSystem, TemporalCRS temporalCRS) {
        int n = AxisDirections.indexOfColinear(coordinateReferenceSystem.getCoordinateSystem(), temporalCRS.getCoordinateSystem());
        assert (n >= 0) : coordinateReferenceSystem;
        DefaultTemporalCRS defaultTemporalCRS = DefaultTemporalCRS.castOrCopy(temporalCRS);
        defaultTemporalExtent.setBounds(defaultTemporalCRS.toDate(envelope.getMinimum(n)), defaultTemporalCRS.toDate(envelope.getMaximum(n)));
    }

    @Override
    public void setBounds(Envelope envelope, DefaultGeographicBoundingBox defaultGeographicBoundingBox) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        GeographicCRS geographicCRS = ReferencingUtilities.toNormalizedGeographicCRS(coordinateReferenceSystem);
        if (geographicCRS == null) {
            if (coordinateReferenceSystem != null) {
                geographicCRS = CommonCRS.defaultGeographic();
            } else if (envelope.getDimension() != 2) {
                throw new TransformException(ServicesForMetadata.dimensionNotFound((short)169, coordinateReferenceSystem));
            }
        }
        this.setGeographicExtent(envelope, defaultGeographicBoundingBox, coordinateReferenceSystem, geographicCRS);
    }

    @Override
    public void setBounds(Envelope envelope, DefaultVerticalExtent defaultVerticalExtent) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        VerticalCRS verticalCRS = CRS.getVerticalComponent(coordinateReferenceSystem, true);
        if (verticalCRS == null && envelope.getDimension() != 1) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)172, coordinateReferenceSystem));
        }
        ServicesForMetadata.setVerticalExtent(envelope, defaultVerticalExtent, coordinateReferenceSystem, verticalCRS);
    }

    @Override
    public void setBounds(Envelope envelope, DefaultTemporalExtent defaultTemporalExtent) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        TemporalCRS temporalCRS = CRS.getTemporalComponent(coordinateReferenceSystem);
        if (temporalCRS == null) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)171, coordinateReferenceSystem));
        }
        ServicesForMetadata.setTemporalExtent(envelope, defaultTemporalExtent, coordinateReferenceSystem, temporalCRS);
    }

    @Override
    public void setBounds(Envelope envelope, DefaultSpatialTemporalExtent defaultSpatialTemporalExtent) throws TransformException {
        Object object;
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        SingleCRS singleCRS = CRS.getHorizontalComponent(coordinateReferenceSystem);
        VerticalCRS verticalCRS = CRS.getVerticalComponent(coordinateReferenceSystem, true);
        TemporalCRS temporalCRS = CRS.getTemporalComponent(coordinateReferenceSystem);
        if (singleCRS == null && verticalCRS == null && temporalCRS == null) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)170, coordinateReferenceSystem));
        }
        DefaultGeographicBoundingBox defaultGeographicBoundingBox = null;
        boolean bl = singleCRS != null;
        Collection<GeographicExtent> collection = defaultSpatialTemporalExtent.getSpatialExtent();
        Iterator<GeographicExtent> iterator = collection.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof GeographicBoundingBox)) continue;
            if (bl && object instanceof DefaultGeographicBoundingBox) {
                defaultGeographicBoundingBox = (DefaultGeographicBoundingBox)object;
                bl = false;
                continue;
            }
            iterator.remove();
        }
        if (singleCRS != null) {
            if (defaultGeographicBoundingBox == null) {
                defaultGeographicBoundingBox = new DefaultGeographicBoundingBox();
                collection.add(defaultGeographicBoundingBox);
            }
            if ((object = ReferencingUtilities.toNormalizedGeographicCRS(coordinateReferenceSystem)) == null) {
                object = CommonCRS.defaultGeographic();
            }
            this.setGeographicExtent(envelope, defaultGeographicBoundingBox, coordinateReferenceSystem, (GeographicCRS)object);
        }
        if (verticalCRS != null) {
            object = defaultSpatialTemporalExtent.getVerticalExtent();
            if (!(object instanceof DefaultVerticalExtent)) {
                object = new DefaultVerticalExtent();
                defaultSpatialTemporalExtent.setVerticalExtent((VerticalExtent)object);
            }
            ServicesForMetadata.setVerticalExtent(envelope, (DefaultVerticalExtent)object, coordinateReferenceSystem, verticalCRS);
        } else {
            defaultSpatialTemporalExtent.setVerticalExtent(null);
        }
        if (temporalCRS != null) {
            ServicesForMetadata.setTemporalExtent(envelope, defaultSpatialTemporalExtent, coordinateReferenceSystem, temporalCRS);
        } else {
            defaultSpatialTemporalExtent.setExtent(null);
        }
    }

    @Override
    public void addElements(Envelope envelope, DefaultExtent defaultExtent) throws TransformException {
        ISOMetadata iSOMetadata;
        CoordinateReferenceSystem coordinateReferenceSystem = envelope.getCoordinateReferenceSystem();
        SingleCRS singleCRS = CRS.getHorizontalComponent(coordinateReferenceSystem);
        VerticalCRS verticalCRS = CRS.getVerticalComponent(coordinateReferenceSystem, true);
        TemporalCRS temporalCRS = CRS.getTemporalComponent(coordinateReferenceSystem);
        if (singleCRS == null && verticalCRS == null && temporalCRS == null) {
            throw new TransformException(ServicesForMetadata.dimensionNotFound((short)170, coordinateReferenceSystem));
        }
        if (singleCRS != null) {
            iSOMetadata = new DefaultGeographicBoundingBox();
            iSOMetadata.setInclusion(Boolean.TRUE);
            this.setBounds(envelope, (DefaultGeographicBoundingBox)iSOMetadata);
            defaultExtent.getGeographicElements().add((GeographicExtent)((Object)iSOMetadata));
        }
        if (verticalCRS != null) {
            iSOMetadata = new DefaultVerticalExtent();
            ServicesForMetadata.setVerticalExtent(envelope, (DefaultVerticalExtent)iSOMetadata, coordinateReferenceSystem, verticalCRS);
            defaultExtent.getVerticalElements().add((VerticalExtent)((Object)iSOMetadata));
        }
        if (temporalCRS != null) {
            iSOMetadata = new DefaultTemporalExtent();
            ServicesForMetadata.setTemporalExtent(envelope, (DefaultTemporalExtent)iSOMetadata, coordinateReferenceSystem, temporalCRS);
            defaultExtent.getTemporalElements().add((TemporalExtent)((Object)iSOMetadata));
        }
    }

    @Override
    public ParameterDescriptor<?> toImplementation(ParameterDescriptor<?> parameterDescriptor) {
        return DefaultParameterDescriptor.castOrCopy(parameterDescriptor);
    }

    @Override
    public FormattableObject toFormattableObject(IdentifiedObject identifiedObject) {
        return AbstractIdentifiedObject.castOrCopy(identifiedObject);
    }

    @Override
    public FormattableObject toFormattableObject(MathTransform mathTransform, boolean bl) {
        ParameterValueGroup parameterValueGroup;
        Matrix matrix;
        if (bl && (matrix = MathTransforms.getMatrix(mathTransform)) != null) {
            parameterValueGroup = Affine.parameters(matrix);
        } else if (mathTransform instanceof Parameterized) {
            parameterValueGroup = ((Parameterized)((Object)mathTransform)).getParameterValues();
        } else {
            matrix = MathTransforms.getMatrix(mathTransform);
            if (matrix == null) {
                return null;
            }
            parameterValueGroup = Affine.parameters(matrix);
        }
        return new FormattableObject(){

            @Override
            protected String formatTo(Formatter formatter) {
                WKTUtilities.appendParamMT(parameterValueGroup, formatter);
                return "Param_MT";
            }
        };
    }

    @Override
    public VerticalCRS getMSLH() {
        return CommonCRS.Vertical.MEAN_SEA_LEVEL.crs();
    }

    @Override
    public PrimeMeridian getGreenwich() {
        return CommonCRS.WGS84.primeMeridian();
    }

    @Override
    public CartesianCS getGeocentricCS(Unit<Length> unit) {
        return Legacy.standard(unit);
    }

    @Override
    public CartesianCS upgradeGeocentricCS(CartesianCS cartesianCS) {
        return Legacy.forGeocentricCRS(cartesianCS, false);
    }

    @Override
    public CoordinateSystem createAbstractCS(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        return new AbstractCS(map, coordinateSystemAxisArray);
    }

    @Override
    public DerivedCRS createDerivedCRS(Map<String, ?> map, SingleCRS singleCRS, OperationMethod operationMethod, MathTransform mathTransform, CoordinateSystem coordinateSystem) {
        return DefaultDerivedCRS.create(map, singleCRS, null, operationMethod, mathTransform, coordinateSystem);
    }

    @Override
    public AxisDirection directionAlongMeridian(AxisDirection axisDirection, double d) {
        return CoordinateSystems.directionAlongMeridian(axisDirection, d);
    }

    @Override
    public Object createToWGS84(double[] dArray) {
        BursaWolfParameters bursaWolfParameters = new BursaWolfParameters(CommonCRS.WGS84.datum(), null);
        bursaWolfParameters.setValues(dArray);
        return bursaWolfParameters;
    }

    @Override
    public SingleOperation createSingleOperation(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateReferenceSystem coordinateReferenceSystem3, OperationMethod operationMethod, CoordinateOperationFactory coordinateOperationFactory) throws FactoryException {
        DefaultCoordinateOperationFactory defaultCoordinateOperationFactory = coordinateOperationFactory instanceof DefaultCoordinateOperationFactory ? (DefaultCoordinateOperationFactory)coordinateOperationFactory : DefaultFactories.forBuildin(CoordinateOperationFactory.class, DefaultCoordinateOperationFactory.class);
        return defaultCoordinateOperationFactory.createSingleOperation(map, coordinateReferenceSystem, coordinateReferenceSystem2, coordinateReferenceSystem3, operationMethod, null);
    }

    @Override
    public CoordinateOperationFactory getCoordinateOperationFactory(Map<String, ?> map, MathTransformFactory mathTransformFactory) {
        if (Containers.isNullOrEmpty(map) && DefaultFactories.isDefaultInstance(MathTransformFactory.class, mathTransformFactory)) {
            return DefaultFactories.forBuildin(CoordinateOperationFactory.class);
        }
        return new DefaultCoordinateOperationFactory(map, mathTransformFactory);
    }

    @Override
    public Map<String, ?> getProperties(IdentifiedObject identifiedObject) {
        return IdentifiedObjects.getProperties(identifiedObject, new String[0]);
    }

    @Override
    public boolean isHeuristicMatchForName(IdentifiedObject identifiedObject, String string) {
        return IdentifiedObjects.isHeuristicMatchForName(identifiedObject, string);
    }

    @Override
    public OperationMethod getOperationMethod(CoordinateOperationFactory coordinateOperationFactory, MathTransformFactory mathTransformFactory, String string) throws FactoryException {
        if (coordinateOperationFactory instanceof DefaultCoordinateOperationFactory) {
            ((DefaultCoordinateOperationFactory)coordinateOperationFactory).getOperationMethod(string);
        }
        return super.getOperationMethod(coordinateOperationFactory, mathTransformFactory, string);
    }
}

