/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.geodistance;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.FacetParser;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacet;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacetExecutor;
import org.elasticsearch.search.facet.geodistance.InternalGeoDistanceFacet;
import org.elasticsearch.search.facet.geodistance.ScriptGeoDistanceFacetExecutor;
import org.elasticsearch.search.facet.geodistance.ValueGeoDistanceFacetExecutor;
import org.elasticsearch.search.internal.SearchContext;

public class GeoDistanceFacetParser
extends AbstractComponent
implements FacetParser {
    @Inject
    public GeoDistanceFacetParser(Settings settings) {
        super(settings);
        InternalGeoDistanceFacet.registerStreams();
    }

    @Override
    public String[] types() {
        return new String[]{"geo_distance", "geoDistance"};
    }

    @Override
    public FacetExecutor.Mode defaultMainMode() {
        return FacetExecutor.Mode.COLLECTOR;
    }

    @Override
    public FacetExecutor.Mode defaultGlobalMode() {
        return FacetExecutor.Mode.COLLECTOR;
    }

    @Override
    public FacetExecutor parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        FieldMapper keyFieldMapper;
        XContentParser.Token token;
        String fieldName = null;
        String valueFieldName = null;
        String valueScript = null;
        String scriptLang = null;
        Map<String, Object> params = null;
        GeoPoint point = new GeoPoint();
        DistanceUnit unit = DistanceUnit.DEFAULT;
        GeoDistance geoDistance = GeoDistance.DEFAULT;
        ArrayList<GeoDistanceFacet.Entry> entries = Lists.newArrayList();
        boolean normalizeLon = true;
        boolean normalizeLat = true;
        String currentName = parser.currentName();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("ranges".equals(currentName) || "entries".equals(currentName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        double from = Double.NEGATIVE_INFINITY;
                        double to = Double.POSITIVE_INFINITY;
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentName = parser.currentName();
                                continue;
                            }
                            if (!token.isValue()) continue;
                            if ("from".equals(currentName)) {
                                from = parser.doubleValue();
                                continue;
                            }
                            if (!"to".equals(currentName)) continue;
                            to = parser.doubleValue();
                        }
                        entries.add(new GeoDistanceFacet.Entry(from, to, 0L, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY));
                    }
                    continue;
                }
                GeoPoint.parse(parser, point);
                fieldName = currentName;
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("params".equals(currentName)) {
                    params = parser.map();
                    continue;
                }
                fieldName = currentName;
                GeoPoint.parse(parser, point);
                continue;
            }
            if (!token.isValue()) continue;
            if (currentName.equals("unit")) {
                unit = DistanceUnit.fromString(parser.text());
                continue;
            }
            if (currentName.equals("distance_type") || currentName.equals("distanceType")) {
                geoDistance = GeoDistance.fromString(parser.text());
                continue;
            }
            if ("value_field".equals(currentName) || "valueField".equals(currentName)) {
                valueFieldName = parser.text();
                continue;
            }
            if ("value_script".equals(currentName) || "valueScript".equals(currentName)) {
                valueScript = parser.text();
                continue;
            }
            if ("lang".equals(currentName)) {
                scriptLang = parser.text();
                continue;
            }
            if ("normalize".equals(currentName)) {
                normalizeLat = parser.booleanValue();
                normalizeLon = parser.booleanValue();
                continue;
            }
            point.resetFromString(parser.text());
            fieldName = currentName;
        }
        if (entries.isEmpty()) {
            throw new FacetPhaseExecutionException(facetName, "no ranges defined for geo_distance facet");
        }
        if (normalizeLat || normalizeLon) {
            GeoUtils.normalizePoint(point, normalizeLat, normalizeLon);
        }
        if ((keyFieldMapper = context.smartNameFieldMapper(fieldName)) == null) {
            throw new FacetPhaseExecutionException(facetName, "failed to find mapping for [" + fieldName + "]");
        }
        IndexGeoPointFieldData keyIndexFieldData = (IndexGeoPointFieldData)context.fieldData().getForField(keyFieldMapper);
        if (valueFieldName != null) {
            FieldMapper valueFieldMapper = context.smartNameFieldMapper(valueFieldName);
            if (valueFieldMapper == null) {
                throw new FacetPhaseExecutionException(facetName, "failed to find mapping for [" + valueFieldName + "]");
            }
            IndexNumericFieldData valueIndexFieldData = (IndexNumericFieldData)context.fieldData().getForField(valueFieldMapper);
            return new ValueGeoDistanceFacetExecutor(keyIndexFieldData, point.lat(), point.lon(), unit, geoDistance, entries.toArray(new GeoDistanceFacet.Entry[entries.size()]), context, valueIndexFieldData);
        }
        if (valueScript != null) {
            return new ScriptGeoDistanceFacetExecutor(keyIndexFieldData, point.lat(), point.lon(), unit, geoDistance, entries.toArray(new GeoDistanceFacet.Entry[entries.size()]), context, scriptLang, valueScript, params);
        }
        return new GeoDistanceFacetExecutor(keyIndexFieldData, point.lat(), point.lon(), unit, geoDistance, entries.toArray(new GeoDistanceFacet.Entry[entries.size()]), context);
    }
}

