/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.UnicodeUtil;

public class IncludeExclude {
    private final Matcher include;
    private final Matcher exclude;
    private final CharsRef scratch = new CharsRef();

    public IncludeExclude(Pattern include, Pattern exclude) {
        assert (include != null || exclude != null) : "include & exclude cannot both be null";
        this.include = include != null ? include.matcher("") : null;
        this.exclude = exclude != null ? exclude.matcher("") : null;
    }

    public boolean accept(BytesRef value) {
        UnicodeUtil.UTF8toUTF16((BytesRef)value, (CharsRef)this.scratch);
        if (this.include == null) {
            return !this.exclude.reset((CharSequence)this.scratch).matches();
        }
        if (!this.include.reset((CharSequence)this.scratch).matches()) {
            return false;
        }
        if (this.exclude == null) {
            return true;
        }
        return !this.exclude.reset((CharSequence)this.scratch).matches();
    }
}

