/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filter;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.ReaderContextAware;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilter;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class FilterAggregator
extends SingleBucketAggregator
implements ReaderContextAware {
    private final Filter filter;
    private Bits bits;

    public FilterAggregator(String name, Filter filter, AggregatorFactories factories, AggregationContext aggregationContext, Aggregator parent) {
        super(name, factories, aggregationContext, parent);
        this.filter = filter;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        try {
            this.bits = DocIdSets.toSafeBits(reader.reader(), this.filter.getDocIdSet(reader, reader.reader().getLiveDocs()));
        }
        catch (IOException ioe) {
            throw new AggregationExecutionException("Failed to aggregate filter aggregator [" + this.name + "]", ioe);
        }
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        if (this.bits.get(doc)) {
            this.collectBucket(doc, owningBucketOrdinal);
        }
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        return new InternalFilter(this.name, this.bucketDocCount(owningBucketOrdinal), this.bucketAggregations(owningBucketOrdinal));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalFilter(this.name, 0L, this.buildEmptySubAggregations());
    }

    public static class Factory
    extends AggregatorFactory {
        private Filter filter;

        public Factory(String name, Filter filter) {
            super(name, InternalFilter.TYPE.name());
            this.filter = filter;
        }

        @Override
        public Aggregator create(AggregationContext context, Aggregator parent, long expectedBucketsCount) {
            FilterAggregator aggregator = new FilterAggregator(this.name, this.filter, this.factories, context, parent);
            context.registerReaderContextAware(aggregator);
            return aggregator;
        }
    }
}

