/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.internal.SearchContext;

public class AggregatorParsers {
    private final ImmutableMap<String, Aggregator.Parser> parsers;

    @Inject
    public AggregatorParsers(Set<Aggregator.Parser> parsers) {
        MapBuilder<String, Aggregator.Parser> builder = MapBuilder.newMapBuilder();
        for (Aggregator.Parser parser : parsers) {
            builder.put(parser.type(), parser);
        }
        this.parsers = builder.immutableMap();
    }

    public Aggregator.Parser parser(String type) {
        return this.parsers.get(type);
    }

    public AggregatorFactories parseAggregators(XContentParser parser, SearchContext context) throws IOException {
        return this.parseAggregators(parser, context, 0);
    }

    private AggregatorFactories parseAggregators(XContentParser parser, SearchContext context, int level) throws IOException {
        XContentParser.Token token = null;
        String currentFieldName = null;
        AggregatorFactories.Builder factories = new AggregatorFactories.Builder();
        String aggregationName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                aggregationName = parser.currentName();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            String aggregatorType = null;
            AggregatorFactory factory = null;
            AggregatorFactories subFactories = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT) continue;
                if ("aggregations".equals(currentFieldName) || "aggs".equals(currentFieldName)) {
                    subFactories = this.parseAggregators(parser, context, level + 1);
                    continue;
                }
                if (aggregatorType != null) {
                    throw new SearchParseException(context, "Found two aggregation type definitions in [" + aggregationName + "]: [" + aggregatorType + "] and [" + currentFieldName + "]. Only one type is allowed.");
                }
                aggregatorType = currentFieldName;
                Aggregator.Parser aggregatorParser = this.parser(aggregatorType);
                if (aggregatorParser == null) {
                    throw new SearchParseException(context, "Could not find aggregator type [" + currentFieldName + "]");
                }
                factory = aggregatorParser.parse(aggregationName, parser, context);
            }
            if (factory == null) continue;
            if (subFactories != null) {
                factory.subFactories(subFactories);
            }
            if (level == 0) {
                factory.validate();
            }
            factories.add(factory);
        }
        return factories.build();
    }
}

