/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.action;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchSearchRequest;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.fetch.ScrollQueryFetchSearchResult;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.ScrollQuerySearchResult;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class SearchServiceTransportAction
extends AbstractComponent {
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final SearchService searchService;
    private final FreeContextResponseHandler freeContextResponseHandler;

    @Inject
    public SearchServiceTransportAction(Settings settings, TransportService transportService, ClusterService clusterService, SearchService searchService) {
        super(settings);
        this.freeContextResponseHandler = new FreeContextResponseHandler(this.logger);
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.searchService = searchService;
        transportService.registerHandler("search/freeContext", new SearchFreeContextTransportHandler());
        transportService.registerHandler("search/clearScrollContexts", new ClearScrollContextsTransportHandler());
        transportService.registerHandler("search/phase/dfs", new SearchDfsTransportHandler());
        transportService.registerHandler("search/phase/query", new SearchQueryTransportHandler());
        transportService.registerHandler("search/phase/query/id", new SearchQueryByIdTransportHandler());
        transportService.registerHandler("search/phase/query/scroll", new SearchQueryScrollTransportHandler());
        transportService.registerHandler("search/phase/query+fetch", new SearchQueryFetchTransportHandler());
        transportService.registerHandler("search/phase/query/query+fetch", new SearchQueryQueryFetchTransportHandler());
        transportService.registerHandler("search/phase/query+fetch/scroll", new SearchQueryFetchScrollTransportHandler());
        transportService.registerHandler("search/phase/fetch/id", new SearchFetchByIdTransportHandler());
        transportService.registerHandler("search/phase/scan", new SearchScanTransportHandler());
        transportService.registerHandler("search/phase/scan/scroll", new SearchScanScrollTransportHandler());
    }

    public void sendFreeContext(DiscoveryNode node, long contextId, SearchRequest request) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            this.searchService.freeContext(contextId);
        } else {
            this.transportService.sendRequest(node, "search/freeContext", new SearchFreeContextRequest(request, contextId), this.freeContextResponseHandler);
        }
    }

    public void sendFreeContext(DiscoveryNode node, long contextId, ClearScrollRequest request, final ActionListener<Boolean> actionListener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            this.searchService.freeContext(contextId);
            actionListener.onResponse(true);
        } else {
            this.transportService.sendRequest(node, "search/freeContext", new SearchFreeContextRequest(request, contextId), new TransportResponseHandler<TransportResponse>(){

                @Override
                public TransportResponse newInstance() {
                    return TransportResponse.Empty.INSTANCE;
                }

                @Override
                public void handleResponse(TransportResponse response) {
                    actionListener.onResponse(true);
                }

                @Override
                public void handleException(TransportException exp) {
                    actionListener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendClearAllScrollContexts(DiscoveryNode node, ClearScrollRequest request, final ActionListener<Boolean> actionListener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            this.searchService.freeAllScrollContexts();
            actionListener.onResponse(true);
        } else {
            this.transportService.sendRequest(node, "search/clearScrollContexts", new ClearScrollContextsRequest(request), new TransportResponseHandler<TransportResponse>(){

                @Override
                public TransportResponse newInstance() {
                    return TransportResponse.Empty.INSTANCE;
                }

                @Override
                public void handleResponse(TransportResponse response) {
                    actionListener.onResponse(true);
                }

                @Override
                public void handleException(TransportException exp) {
                    actionListener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteDfs(DiscoveryNode node, ShardSearchRequest request, final SearchServiceListener<DfsSearchResult> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            try {
                DfsSearchResult result = this.searchService.executeDfsPhase(request);
                listener.onResult(result);
            }
            catch (Throwable e) {
                listener.onFailure(e);
            }
        } else {
            this.transportService.sendRequest(node, "search/phase/dfs", request, new BaseTransportResponseHandler<DfsSearchResult>(){

                @Override
                public DfsSearchResult newInstance() {
                    return new DfsSearchResult();
                }

                @Override
                public void handleResponse(DfsSearchResult response) {
                    listener.onResult(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteQuery(DiscoveryNode node, ShardSearchRequest request, final SearchServiceListener<QuerySearchResult> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            try {
                QuerySearchResult result = this.searchService.executeQueryPhase(request);
                listener.onResult(result);
            }
            catch (Throwable e) {
                listener.onFailure(e);
            }
        } else {
            this.transportService.sendRequest(node, "search/phase/query", request, new BaseTransportResponseHandler<QuerySearchResult>(){

                @Override
                public QuerySearchResult newInstance() {
                    return new QuerySearchResult();
                }

                @Override
                public void handleResponse(QuerySearchResult response) {
                    listener.onResult(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteQuery(DiscoveryNode node, QuerySearchRequest request, final SearchServiceListener<QuerySearchResult> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            try {
                QuerySearchResult result = this.searchService.executeQueryPhase(request);
                listener.onResult(result);
            }
            catch (Throwable e) {
                listener.onFailure(e);
            }
        } else {
            this.transportService.sendRequest(node, "search/phase/query/id", request, new BaseTransportResponseHandler<QuerySearchResult>(){

                @Override
                public QuerySearchResult newInstance() {
                    return new QuerySearchResult();
                }

                @Override
                public void handleResponse(QuerySearchResult response) {
                    listener.onResult(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteQuery(DiscoveryNode node, InternalScrollSearchRequest request, final SearchServiceListener<QuerySearchResult> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            try {
                ScrollQuerySearchResult result = this.searchService.executeQueryPhase(request);
                listener.onResult(result.queryResult());
            }
            catch (Throwable e) {
                listener.onFailure(e);
            }
        } else {
            this.transportService.sendRequest(node, "search/phase/query/scroll", request, new BaseTransportResponseHandler<ScrollQuerySearchResult>(){

                @Override
                public ScrollQuerySearchResult newInstance() {
                    return new ScrollQuerySearchResult();
                }

                @Override
                public void handleResponse(ScrollQuerySearchResult response) {
                    listener.onResult(response.queryResult());
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteFetch(DiscoveryNode node, ShardSearchRequest request, final SearchServiceListener<QueryFetchSearchResult> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            try {
                QueryFetchSearchResult result = this.searchService.executeFetchPhase(request);
                listener.onResult(result);
            }
            catch (Throwable e) {
                listener.onFailure(e);
            }
        } else {
            this.transportService.sendRequest(node, "search/phase/query+fetch", request, new BaseTransportResponseHandler<QueryFetchSearchResult>(){

                @Override
                public QueryFetchSearchResult newInstance() {
                    return new QueryFetchSearchResult();
                }

                @Override
                public void handleResponse(QueryFetchSearchResult response) {
                    listener.onResult(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteFetch(DiscoveryNode node, QuerySearchRequest request, final SearchServiceListener<QueryFetchSearchResult> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            try {
                QueryFetchSearchResult result = this.searchService.executeFetchPhase(request);
                listener.onResult(result);
            }
            catch (Throwable e) {
                listener.onFailure(e);
            }
        } else {
            this.transportService.sendRequest(node, "search/phase/query/query+fetch", request, new BaseTransportResponseHandler<QueryFetchSearchResult>(){

                @Override
                public QueryFetchSearchResult newInstance() {
                    return new QueryFetchSearchResult();
                }

                @Override
                public void handleResponse(QueryFetchSearchResult response) {
                    listener.onResult(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteFetch(DiscoveryNode node, InternalScrollSearchRequest request, final SearchServiceListener<QueryFetchSearchResult> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            try {
                ScrollQueryFetchSearchResult result = this.searchService.executeFetchPhase(request);
                listener.onResult(result.result());
            }
            catch (Throwable e) {
                listener.onFailure(e);
            }
        } else {
            this.transportService.sendRequest(node, "search/phase/query+fetch/scroll", request, new BaseTransportResponseHandler<ScrollQueryFetchSearchResult>(){

                @Override
                public ScrollQueryFetchSearchResult newInstance() {
                    return new ScrollQueryFetchSearchResult();
                }

                @Override
                public void handleResponse(ScrollQueryFetchSearchResult response) {
                    listener.onResult(response.result());
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteFetch(DiscoveryNode node, FetchSearchRequest request, final SearchServiceListener<FetchSearchResult> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            try {
                FetchSearchResult result = this.searchService.executeFetchPhase(request);
                listener.onResult(result);
            }
            catch (Throwable e) {
                listener.onFailure(e);
            }
        } else {
            this.transportService.sendRequest(node, "search/phase/fetch/id", request, new BaseTransportResponseHandler<FetchSearchResult>(){

                @Override
                public FetchSearchResult newInstance() {
                    return new FetchSearchResult();
                }

                @Override
                public void handleResponse(FetchSearchResult response) {
                    listener.onResult(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteScan(DiscoveryNode node, ShardSearchRequest request, final SearchServiceListener<QuerySearchResult> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            try {
                QuerySearchResult result = this.searchService.executeScan(request);
                listener.onResult(result);
            }
            catch (Throwable e) {
                listener.onFailure(e);
            }
        } else {
            this.transportService.sendRequest(node, "search/phase/scan", request, new BaseTransportResponseHandler<QuerySearchResult>(){

                @Override
                public QuerySearchResult newInstance() {
                    return new QuerySearchResult();
                }

                @Override
                public void handleResponse(QuerySearchResult response) {
                    listener.onResult(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    public void sendExecuteScan(DiscoveryNode node, InternalScrollSearchRequest request, final SearchServiceListener<QueryFetchSearchResult> listener) {
        if (this.clusterService.state().nodes().localNodeId().equals(node.id())) {
            try {
                ScrollQueryFetchSearchResult result = this.searchService.executeScan(request);
                listener.onResult(result.result());
            }
            catch (Throwable e) {
                listener.onFailure(e);
            }
        } else {
            this.transportService.sendRequest(node, "search/phase/scan/scroll", request, new BaseTransportResponseHandler<ScrollQueryFetchSearchResult>(){

                @Override
                public ScrollQueryFetchSearchResult newInstance() {
                    return new ScrollQueryFetchSearchResult();
                }

                @Override
                public void handleResponse(ScrollQueryFetchSearchResult response) {
                    listener.onResult(response.result());
                }

                @Override
                public void handleException(TransportException exp) {
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    private class SearchScanScrollTransportHandler
    extends BaseTransportRequestHandler<InternalScrollSearchRequest> {
        static final String ACTION = "search/phase/scan/scroll";

        private SearchScanScrollTransportHandler() {
        }

        @Override
        public InternalScrollSearchRequest newInstance() {
            return new InternalScrollSearchRequest();
        }

        @Override
        public void messageReceived(InternalScrollSearchRequest request, TransportChannel channel) throws Exception {
            ScrollQueryFetchSearchResult result = SearchServiceTransportAction.this.searchService.executeScan(request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    private class SearchScanTransportHandler
    extends BaseTransportRequestHandler<ShardSearchRequest> {
        static final String ACTION = "search/phase/scan";

        private SearchScanTransportHandler() {
        }

        @Override
        public ShardSearchRequest newInstance() {
            return new ShardSearchRequest();
        }

        @Override
        public void messageReceived(ShardSearchRequest request, TransportChannel channel) throws Exception {
            QuerySearchResult result = SearchServiceTransportAction.this.searchService.executeScan(request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    private class SearchQueryFetchScrollTransportHandler
    extends BaseTransportRequestHandler<InternalScrollSearchRequest> {
        static final String ACTION = "search/phase/query+fetch/scroll";

        private SearchQueryFetchScrollTransportHandler() {
        }

        @Override
        public InternalScrollSearchRequest newInstance() {
            return new InternalScrollSearchRequest();
        }

        @Override
        public void messageReceived(InternalScrollSearchRequest request, TransportChannel channel) throws Exception {
            ScrollQueryFetchSearchResult result = SearchServiceTransportAction.this.searchService.executeFetchPhase(request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    private class SearchFetchByIdTransportHandler
    extends BaseTransportRequestHandler<FetchSearchRequest> {
        static final String ACTION = "search/phase/fetch/id";

        private SearchFetchByIdTransportHandler() {
        }

        @Override
        public FetchSearchRequest newInstance() {
            return new FetchSearchRequest();
        }

        @Override
        public void messageReceived(FetchSearchRequest request, TransportChannel channel) throws Exception {
            FetchSearchResult result = SearchServiceTransportAction.this.searchService.executeFetchPhase(request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    private class SearchQueryQueryFetchTransportHandler
    extends BaseTransportRequestHandler<QuerySearchRequest> {
        static final String ACTION = "search/phase/query/query+fetch";

        private SearchQueryQueryFetchTransportHandler() {
        }

        @Override
        public QuerySearchRequest newInstance() {
            return new QuerySearchRequest();
        }

        @Override
        public void messageReceived(QuerySearchRequest request, TransportChannel channel) throws Exception {
            QueryFetchSearchResult result = SearchServiceTransportAction.this.searchService.executeFetchPhase(request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    private class SearchQueryFetchTransportHandler
    extends BaseTransportRequestHandler<ShardSearchRequest> {
        static final String ACTION = "search/phase/query+fetch";

        private SearchQueryFetchTransportHandler() {
        }

        @Override
        public ShardSearchRequest newInstance() {
            return new ShardSearchRequest();
        }

        @Override
        public void messageReceived(ShardSearchRequest request, TransportChannel channel) throws Exception {
            QueryFetchSearchResult result = SearchServiceTransportAction.this.searchService.executeFetchPhase(request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    private class SearchQueryScrollTransportHandler
    extends BaseTransportRequestHandler<InternalScrollSearchRequest> {
        static final String ACTION = "search/phase/query/scroll";

        private SearchQueryScrollTransportHandler() {
        }

        @Override
        public InternalScrollSearchRequest newInstance() {
            return new InternalScrollSearchRequest();
        }

        @Override
        public void messageReceived(InternalScrollSearchRequest request, TransportChannel channel) throws Exception {
            ScrollQuerySearchResult result = SearchServiceTransportAction.this.searchService.executeQueryPhase(request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    private class SearchQueryByIdTransportHandler
    extends BaseTransportRequestHandler<QuerySearchRequest> {
        static final String ACTION = "search/phase/query/id";

        private SearchQueryByIdTransportHandler() {
        }

        @Override
        public QuerySearchRequest newInstance() {
            return new QuerySearchRequest();
        }

        @Override
        public void messageReceived(QuerySearchRequest request, TransportChannel channel) throws Exception {
            QuerySearchResult result = SearchServiceTransportAction.this.searchService.executeQueryPhase(request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    private class SearchQueryTransportHandler
    extends BaseTransportRequestHandler<ShardSearchRequest> {
        static final String ACTION = "search/phase/query";

        private SearchQueryTransportHandler() {
        }

        @Override
        public ShardSearchRequest newInstance() {
            return new ShardSearchRequest();
        }

        @Override
        public void messageReceived(ShardSearchRequest request, TransportChannel channel) throws Exception {
            QuerySearchResult result = SearchServiceTransportAction.this.searchService.executeQueryPhase(request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    private class SearchDfsTransportHandler
    extends BaseTransportRequestHandler<ShardSearchRequest> {
        static final String ACTION = "search/phase/dfs";

        private SearchDfsTransportHandler() {
        }

        @Override
        public ShardSearchRequest newInstance() {
            return new ShardSearchRequest();
        }

        @Override
        public void messageReceived(ShardSearchRequest request, TransportChannel channel) throws Exception {
            DfsSearchResult result = SearchServiceTransportAction.this.searchService.executeDfsPhase(request);
            channel.sendResponse(result);
        }

        @Override
        public String executor() {
            return "search";
        }
    }

    class ClearScrollContextsTransportHandler
    extends BaseTransportRequestHandler<ClearScrollContextsRequest> {
        static final String ACTION = "search/clearScrollContexts";

        ClearScrollContextsTransportHandler() {
        }

        @Override
        public ClearScrollContextsRequest newInstance() {
            return new ClearScrollContextsRequest();
        }

        @Override
        public void messageReceived(ClearScrollContextsRequest request, TransportChannel channel) throws Exception {
            SearchServiceTransportAction.this.searchService.freeAllScrollContexts();
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    class ClearScrollContextsRequest
    extends TransportRequest {
        ClearScrollContextsRequest() {
        }

        ClearScrollContextsRequest(TransportRequest request) {
            super(request);
        }
    }

    class SearchFreeContextTransportHandler
    extends BaseTransportRequestHandler<SearchFreeContextRequest> {
        static final String ACTION = "search/freeContext";

        SearchFreeContextTransportHandler() {
        }

        @Override
        public SearchFreeContextRequest newInstance() {
            return new SearchFreeContextRequest();
        }

        @Override
        public void messageReceived(SearchFreeContextRequest request, TransportChannel channel) throws Exception {
            SearchServiceTransportAction.this.searchService.freeContext(request.id());
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    class SearchFreeContextRequest
    extends TransportRequest {
        private long id;

        SearchFreeContextRequest() {
        }

        SearchFreeContextRequest(TransportRequest request, long id) {
            super(request);
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.id = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeLong(this.id);
        }
    }

    static final class FreeContextResponseHandler
    extends EmptyTransportResponseHandler {
        private final ESLogger logger;

        FreeContextResponseHandler(ESLogger logger) {
            super("same");
            this.logger = logger;
        }

        @Override
        public void handleException(TransportException exp) {
            this.logger.warn("Failed to send release search context", exp, new Object[0]);
        }
    }
}

