/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.TimeValue;

public class Scroll
implements Streamable {
    private TimeValue keepAlive;

    private Scroll() {
    }

    public Scroll(TimeValue keepAlive) {
        this.keepAlive = keepAlive;
    }

    public TimeValue keepAlive() {
        return this.keepAlive;
    }

    public static Scroll readScroll(StreamInput in) throws IOException {
        Scroll scroll = new Scroll();
        scroll.readFrom(in);
        return scroll;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.keepAlive = TimeValue.readTimeValue(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.keepAlive == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.keepAlive.writeTo(out);
        }
    }
}

