/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import org.elasticsearch.client.Client;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.StringRestResponse;
import org.elasticsearch.rest.action.support.RestTable;

public abstract class AbstractCatAction
extends BaseRestHandler {
    public AbstractCatAction(Settings settings, Client client) {
        super(settings, client);
    }

    abstract void doRequest(RestRequest var1, RestChannel var2);

    abstract void documentation(StringBuilder var1);

    abstract Table getTableWithHeader(RestRequest var1);

    @Override
    public void handleRequest(RestRequest request, RestChannel channel) {
        boolean helpWanted = request.paramAsBoolean("help", false);
        if (helpWanted) {
            Table table = this.getTableWithHeader(request);
            int[] width = RestTable.buildHelpWidths(table, request, false);
            StringBuilder out = new StringBuilder();
            for (Table.Cell cell : table.getHeaders()) {
                RestTable.pad(new Table.Cell(cell.value), width[0], request, out);
                out.append(" | ");
                RestTable.pad(new Table.Cell(cell.attr.containsKey("alias") ? cell.attr.get("alias") : ""), width[1], request, out);
                out.append(" | ");
                RestTable.pad(new Table.Cell(cell.attr.containsKey("desc") ? cell.attr.get("desc") : "not available"), width[2], request, out);
                out.append("\n");
            }
            channel.sendResponse(new StringRestResponse(RestStatus.OK, out.toString()));
        } else {
            this.doRequest(request, channel);
        }
    }
}

