/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.AbstractRestResponse;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class XContentRestResponse
extends AbstractRestResponse {
    private static final byte[] END_JSONP;
    private final BytesRef prefixUtf8Result;
    private final RestStatus status;
    private final XContentBuilder builder;

    public XContentRestResponse(RestRequest request, RestStatus status, XContentBuilder builder) throws IOException {
        if (request == null) {
            throw new ElasticsearchIllegalArgumentException("request must be set");
        }
        this.builder = builder;
        this.status = status;
        this.prefixUtf8Result = XContentRestResponse.startJsonp(request);
    }

    public XContentBuilder builder() {
        return this.builder;
    }

    @Override
    public String contentType() {
        return this.builder.contentType().restContentType();
    }

    @Override
    public boolean contentThreadSafe() {
        return true;
    }

    @Override
    public byte[] content() throws IOException {
        return this.builder.bytes().array();
    }

    @Override
    public int contentLength() throws IOException {
        return this.builder.bytes().length();
    }

    @Override
    public int contentOffset() throws IOException {
        return 0;
    }

    @Override
    public RestStatus status() {
        return this.status;
    }

    @Override
    public byte[] prefixContent() {
        if (this.prefixUtf8Result != null) {
            return this.prefixUtf8Result.bytes;
        }
        return null;
    }

    @Override
    public int prefixContentLength() {
        if (this.prefixUtf8Result != null) {
            return this.prefixUtf8Result.length;
        }
        return 0;
    }

    @Override
    public int prefixContentOffset() {
        if (this.prefixUtf8Result != null) {
            return this.prefixUtf8Result.offset;
        }
        return 0;
    }

    @Override
    public byte[] suffixContent() {
        if (this.prefixUtf8Result != null) {
            return END_JSONP;
        }
        return null;
    }

    @Override
    public int suffixContentLength() {
        if (this.prefixUtf8Result != null) {
            return END_JSONP.length;
        }
        return 0;
    }

    @Override
    public int suffixContentOffset() {
        return 0;
    }

    private static BytesRef startJsonp(RestRequest request) {
        String callback = request.param("callback");
        if (callback == null) {
            return null;
        }
        BytesRef result = new BytesRef();
        UnicodeUtil.UTF16toUTF8((CharSequence)callback, (int)0, (int)callback.length(), (BytesRef)result);
        result.bytes[result.length] = 40;
        ++result.length;
        return result;
    }

    static {
        BytesRef U_END_JSONP = new BytesRef();
        UnicodeUtil.UTF16toUTF8((CharSequence)");", (int)0, (int)");".length(), (BytesRef)U_END_JSONP);
        END_JSONP = new byte[U_END_JSONP.length];
        System.arraycopy(U_END_JSONP.bytes, U_END_JSONP.offset, END_JSONP, 0, U_END_JSONP.length);
    }
}

