/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.cluster.node.info.PluginInfo;
import org.elasticsearch.action.admin.cluster.node.info.PluginsInfo;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.CloseableIndexComponent;
import org.elasticsearch.plugins.Plugin;

public class PluginsService
extends AbstractComponent {
    private static final String ES_PLUGIN_PROPERTIES = "es-plugin.properties";
    private final Environment environment;
    private final ImmutableList<Tuple<PluginInfo, Plugin>> plugins;
    private final ImmutableMap<Plugin, List<OnModuleReference>> onModuleReferences;
    private PluginsInfo cachedPluginsInfo;
    private final TimeValue refreshInterval;
    private long lastRefresh;

    public PluginsService(Settings settings, Environment environment) {
        super(settings);
        String[] defaultPluginsClasses;
        this.environment = environment;
        ImmutableList.Builder tupleBuilder = ImmutableList.builder();
        for (String string : defaultPluginsClasses = settings.getAsArray("plugin.types")) {
            Plugin plugin = this.loadPlugin(string, settings);
            PluginInfo pluginInfo = new PluginInfo(plugin.name(), plugin.description(), this.hasSite(plugin.name()), true, "NA");
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("plugin loaded from settings [{}]", pluginInfo);
            }
            tupleBuilder.add(new Tuple<PluginInfo, Plugin>(pluginInfo, plugin));
        }
        this.loadPluginsIntoClassLoader();
        tupleBuilder.addAll(this.loadPluginsFromClasspath(settings));
        this.plugins = tupleBuilder.build();
        HashMap jvmPlugins = Maps.newHashMap();
        ArrayList<String> sitePlugins = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            jvmPlugins.put(((Plugin)tuple.v2()).name(), tuple.v2());
            if (!((PluginInfo)tuple.v1()).isSite()) continue;
            sitePlugins.add(((PluginInfo)tuple.v1()).getName());
        }
        ImmutableList<Tuple<PluginInfo, Plugin>> tuples = this.loadSitePlugins();
        for (Tuple tuple : tuples) {
            sitePlugins.add(((PluginInfo)tuple.v1()).getName());
        }
        String[] stringArray = settings.getAsArray("plugin.mandatory", null);
        if (stringArray != null) {
            HashSet<String> hashSet = Sets.newHashSet();
            for (String mandatoryPlugin : stringArray) {
                if (jvmPlugins.containsKey(mandatoryPlugin) || sitePlugins.contains(mandatoryPlugin) || hashSet.contains(mandatoryPlugin)) continue;
                hashSet.add(mandatoryPlugin);
            }
            if (!hashSet.isEmpty()) {
                throw new ElasticsearchException("Missing mandatory plugins [" + Strings.collectionToDelimitedString(hashSet, ", ") + "]");
            }
        }
        this.logger.info("loaded {}, sites {}", jvmPlugins.keySet(), sitePlugins);
        MapBuilder mapBuilder = MapBuilder.newMapBuilder();
        for (Plugin plugin : jvmPlugins.values()) {
            ArrayList<OnModuleReference> list = Lists.newArrayList();
            for (Method method : plugin.getClass().getDeclaredMethods()) {
                if (!method.getName().equals("onModule")) continue;
                if (method.getParameterTypes().length == 0 || method.getParameterTypes().length > 1) {
                    this.logger.warn("Plugin: {} implementing onModule with no parameters or more than one parameter", plugin.name());
                    continue;
                }
                Class<?> moduleClass = method.getParameterTypes()[0];
                if (!Module.class.isAssignableFrom(moduleClass)) {
                    this.logger.warn("Plugin: {} implementing onModule by the type is not of Module type {}", plugin.name(), moduleClass);
                    continue;
                }
                method.setAccessible(true);
                list.add(new OnModuleReference(moduleClass, method));
            }
            if (list.isEmpty()) continue;
            mapBuilder.put(plugin, list);
        }
        this.onModuleReferences = mapBuilder.immutableMap();
        this.refreshInterval = this.componentSettings.getAsTime("info_refresh_interval", TimeValue.timeValueSeconds(10L));
    }

    public ImmutableList<Tuple<PluginInfo, Plugin>> plugins() {
        return this.plugins;
    }

    public void processModules(Iterable<Module> modules) {
        for (Module module : modules) {
            this.processModule(module);
        }
    }

    public void processModule(Module module) {
        for (Tuple tuple : this.plugins()) {
            ((Plugin)tuple.v2()).processModule(module);
            List<OnModuleReference> references = this.onModuleReferences.get(tuple.v2());
            if (references == null) continue;
            for (OnModuleReference reference : references) {
                if (!reference.moduleClass.isAssignableFrom(module.getClass())) continue;
                try {
                    reference.onModuleMethod.invoke(tuple.v2(), module);
                }
                catch (Exception e) {
                    this.logger.warn("plugin {}, failed to invoke custom onModule method", e, ((Plugin)tuple.v2()).name());
                }
            }
        }
    }

    public Settings updatedSettings() {
        ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder().put(this.settings);
        for (Tuple tuple : this.plugins) {
            builder.put(((Plugin)tuple.v2()).additionalSettings());
        }
        return builder.build();
    }

    public Collection<Class<? extends Module>> modules() {
        ArrayList<Class<? extends Module>> modules = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            modules.addAll(((Plugin)tuple.v2()).modules());
        }
        return modules;
    }

    public Collection<Module> modules(Settings settings) {
        ArrayList<Module> modules = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            modules.addAll(((Plugin)tuple.v2()).modules(settings));
        }
        return modules;
    }

    public Collection<Class<? extends LifecycleComponent>> services() {
        ArrayList<Class<? extends LifecycleComponent>> services = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            services.addAll(((Plugin)tuple.v2()).services());
        }
        return services;
    }

    public Collection<Class<? extends Module>> indexModules() {
        ArrayList<Class<? extends Module>> modules = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            modules.addAll(((Plugin)tuple.v2()).indexModules());
        }
        return modules;
    }

    public Collection<Module> indexModules(Settings settings) {
        ArrayList<Module> modules = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            modules.addAll(((Plugin)tuple.v2()).indexModules(settings));
        }
        return modules;
    }

    public Collection<Class<? extends CloseableIndexComponent>> indexServices() {
        ArrayList<Class<? extends CloseableIndexComponent>> services = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            services.addAll(((Plugin)tuple.v2()).indexServices());
        }
        return services;
    }

    public Collection<Class<? extends Module>> shardModules() {
        ArrayList<Class<? extends Module>> modules = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            modules.addAll(((Plugin)tuple.v2()).shardModules());
        }
        return modules;
    }

    public Collection<Module> shardModules(Settings settings) {
        ArrayList<Module> modules = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            modules.addAll(((Plugin)tuple.v2()).shardModules(settings));
        }
        return modules;
    }

    public Collection<Class<? extends CloseableIndexComponent>> shardServices() {
        ArrayList<Class<? extends CloseableIndexComponent>> services = Lists.newArrayList();
        for (Tuple tuple : this.plugins) {
            services.addAll(((Plugin)tuple.v2()).shardServices());
        }
        return services;
    }

    public synchronized PluginsInfo info() {
        if (this.refreshInterval.millis() != 0L) {
            if (this.cachedPluginsInfo != null && (this.refreshInterval.millis() < 0L || System.currentTimeMillis() - this.lastRefresh < this.refreshInterval.millis())) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("using cache to retrieve plugins info", new Object[0]);
                }
                return this.cachedPluginsInfo;
            }
            this.lastRefresh = System.currentTimeMillis();
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("starting to fetch info on plugins", new Object[0]);
        }
        this.cachedPluginsInfo = new PluginsInfo();
        for (Tuple tuple : this.plugins) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("adding jvm plugin [{}]", tuple.v1());
            }
            this.cachedPluginsInfo.add((PluginInfo)tuple.v1());
        }
        for (Tuple tuple : this.loadSitePlugins()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("adding site plugin [{}]", tuple.v1());
            }
            this.cachedPluginsInfo.add((PluginInfo)tuple.v1());
        }
        return this.cachedPluginsInfo;
    }

    private void loadPluginsIntoClassLoader() {
        File pluginsFile = this.environment.pluginsFile();
        if (!pluginsFile.exists()) {
            return;
        }
        if (!pluginsFile.isDirectory()) {
            return;
        }
        ClassLoader classLoader = this.settings.getClassLoader();
        Class<?> classLoaderClass = classLoader.getClass();
        Method addURL = null;
        while (!classLoaderClass.equals(Object.class)) {
            try {
                addURL = classLoaderClass.getDeclaredMethod("addURL", URL.class);
                addURL.setAccessible(true);
                break;
            }
            catch (NoSuchMethodException e) {
                classLoaderClass = classLoaderClass.getSuperclass();
            }
        }
        if (addURL == null) {
            this.logger.debug("failed to find addURL method on classLoader [" + classLoader + "] to add methods", new Object[0]);
            return;
        }
        File[] pluginsFiles = pluginsFile.listFiles();
        if (pluginsFile != null) {
            for (File pluginFile : pluginsFiles) {
                if (!pluginFile.isDirectory()) continue;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("--- adding plugin [" + pluginFile.getAbsolutePath() + "]", new Object[0]);
                }
                try {
                    File libLocation;
                    addURL.invoke((Object)classLoader, pluginFile.toURI().toURL());
                    ArrayList<File> libFiles = Lists.newArrayList();
                    if (pluginFile.listFiles() != null) {
                        libFiles.addAll(Arrays.asList(pluginFile.listFiles()));
                    }
                    if ((libLocation = new File(pluginFile, "lib")).exists() && libLocation.isDirectory() && libLocation.listFiles() != null) {
                        libFiles.addAll(Arrays.asList(libLocation.listFiles()));
                    }
                    for (File libFile : libFiles) {
                        if (!libFile.getName().endsWith(".jar") && !libFile.getName().endsWith(".zip")) continue;
                        addURL.invoke((Object)classLoader, libFile.toURI().toURL());
                    }
                }
                catch (Throwable e) {
                    this.logger.warn("failed to add plugin [" + pluginFile + "]", e, new Object[0]);
                }
            }
        } else {
            this.logger.debug("failed to list plugins from {}. Check your right access.", pluginsFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ImmutableList<Tuple<PluginInfo, Plugin>> loadPluginsFromClasspath(Settings settings) {
        ImmutableList.Builder plugins = ImmutableList.builder();
        try {
            Enumeration<URL> pluginUrls = settings.getClassLoader().getResources(ES_PLUGIN_PROPERTIES);
            while (pluginUrls.hasMoreElements()) {
                URL pluginUrl = pluginUrls.nextElement();
                Properties pluginProps = new Properties();
                InputStream is = null;
                try {
                    boolean isSite;
                    is = pluginUrl.openStream();
                    pluginProps.load(is);
                    String pluginClassName = pluginProps.getProperty("plugin");
                    String pluginVersion = pluginProps.getProperty("version", "NA");
                    Plugin plugin = this.loadPlugin(pluginClassName, settings);
                    File siteFile = new File(new File(this.environment.pluginsFile(), plugin.name()), "_site");
                    boolean bl = isSite = siteFile.exists() && siteFile.isDirectory();
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("found a jvm plugin [{}], [{}]{}", plugin.name(), plugin.description(), isSite ? ": with _site structure" : "");
                    }
                    PluginInfo pluginInfo = new PluginInfo(plugin.name(), plugin.description(), isSite, true, pluginVersion);
                    plugins.add(new Tuple<PluginInfo, Plugin>(pluginInfo, plugin));
                }
                catch (Throwable e) {
                    try {
                        this.logger.warn("failed to load plugin from [" + pluginUrl + "]", e, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
                        throw throwable;
                        return plugins.build();
                    }
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
                    continue;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
            }
        }
        catch (IOException e) {
            this.logger.warn("failed to find jvm plugins from classpath", e, new Object[0]);
        }
        return plugins.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImmutableList<Tuple<PluginInfo, Plugin>> loadSitePlugins() {
        ImmutableList.Builder sitePlugins = ImmutableList.builder();
        ArrayList<String> loadedJvmPlugins = new ArrayList<String>();
        for (Tuple tuple : this.plugins) {
            if (!((PluginInfo)tuple.v1()).isSite()) continue;
            loadedJvmPlugins.add(((PluginInfo)tuple.v1()).getName());
        }
        File pluginsFile = this.environment.pluginsFile();
        if (!pluginsFile.exists() || !pluginsFile.isDirectory()) {
            return sitePlugins.build();
        }
        for (File pluginFile : pluginsFile.listFiles()) {
            File sitePluginDir;
            if (loadedJvmPlugins.contains(pluginFile.getName()) || !(sitePluginDir = new File(pluginFile, "_site")).exists()) continue;
            String name = pluginFile.getName();
            String version = "NA";
            String description = "No description found.";
            File pluginPropFile = new File(sitePluginDir, ES_PLUGIN_PROPERTIES);
            if (pluginPropFile.exists()) {
                Properties pluginProps = new Properties();
                FileInputStream is = null;
                try {
                    is = new FileInputStream(pluginPropFile.getAbsolutePath());
                    pluginProps.load(is);
                    description = pluginProps.getProperty("description", "No description found.");
                    version = pluginProps.getProperty("version", "NA");
                }
                catch (Exception e) {
                    try {
                        this.logger.debug("can not load {} file.", e, ES_PLUGIN_PROPERTIES);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("found a site plugin name [{}], version [{}], description [{}]", name, version, description);
            }
            sitePlugins.add(new Tuple<PluginInfo, Object>(new PluginInfo(name, description, true, false, version), null));
        }
        return sitePlugins.build();
    }

    private boolean hasSite(String name) {
        File pluginsFile = this.environment.pluginsFile();
        if (!pluginsFile.exists() || !pluginsFile.isDirectory()) {
            return false;
        }
        File sitePluginDir = new File(pluginsFile, name + "/_site");
        return sitePluginDir.exists();
    }

    private Plugin loadPlugin(String className, Settings settings) {
        try {
            Plugin plugin;
            Class<?> pluginClass = settings.getClassLoader().loadClass(className);
            try {
                plugin = (Plugin)pluginClass.getConstructor(Settings.class).newInstance(settings);
            }
            catch (NoSuchMethodException e) {
                try {
                    plugin = (Plugin)pluginClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e1) {
                    throw new ElasticsearchException("No constructor for [" + pluginClass + "]. A plugin class must " + "have either an empty default constructor or a single argument constructor accepting a " + "Settings instance");
                }
            }
            return plugin;
        }
        catch (Throwable e) {
            throw new ElasticsearchException("Failed to load plugin class [" + className + "]", e);
        }
    }

    static class OnModuleReference {
        public final Class<? extends Module> moduleClass;
        public final Method onModuleMethod;

        OnModuleReference(Class<? extends Module> moduleClass, Method onModuleMethod) {
            this.moduleClass = moduleClass;
            this.onModuleMethod = onModuleMethod;
        }
    }
}

