/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.process;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class ProcessStats
implements Streamable,
Serializable,
ToXContent {
    long timestamp = -1L;
    long openFileDescriptors;
    Cpu cpu = null;
    Mem mem = null;

    ProcessStats() {
    }

    public long timestamp() {
        return this.timestamp;
    }

    public long getTimestamp() {
        return this.timestamp();
    }

    public long openFileDescriptors() {
        return this.openFileDescriptors;
    }

    public long getOpenFileDescriptors() {
        return this.openFileDescriptors;
    }

    public Cpu cpu() {
        return this.cpu;
    }

    public Cpu getCpu() {
        return this.cpu();
    }

    public Mem mem() {
        return this.mem;
    }

    public Mem getMem() {
        return this.mem();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.PROCESS);
        builder.field(Fields.TIMESTAMP, this.timestamp);
        builder.field(Fields.OPEN_FILE_DESCRIPTORS, this.openFileDescriptors);
        if (this.cpu != null) {
            builder.startObject(Fields.CPU);
            builder.field(Fields.PERCENT, (int)this.cpu.percent());
            builder.timeValueField(Fields.SYS_IN_MILLIS, Fields.SYS, this.cpu.sys);
            builder.timeValueField(Fields.USER_IN_MILLIS, Fields.USER, this.cpu.user);
            builder.timeValueField(Fields.TOTAL_IN_MILLIS, Fields.TOTAL, this.cpu.total);
            builder.endObject();
        }
        if (this.mem != null) {
            builder.startObject(Fields.MEM);
            builder.byteSizeField(Fields.RESIDENT_IN_BYTES, Fields.RESIDENT, this.mem.resident);
            builder.byteSizeField(Fields.SHARE_IN_BYTES, Fields.SHARE, this.mem.share);
            builder.byteSizeField(Fields.TOTAL_VIRTUAL_IN_BYTES, Fields.TOTAL_VIRTUAL, this.mem.totalVirtual);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static ProcessStats readProcessStats(StreamInput in) throws IOException {
        ProcessStats stats = new ProcessStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.openFileDescriptors = in.readLong();
        if (in.readBoolean()) {
            this.cpu = Cpu.readCpu(in);
        }
        if (in.readBoolean()) {
            this.mem = Mem.readMem(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        out.writeLong(this.openFileDescriptors);
        if (this.cpu == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.cpu.writeTo(out);
        }
        if (this.mem == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.mem.writeTo(out);
        }
    }

    public static class Cpu
    implements Streamable,
    Serializable {
        short percent = (short)-1;
        long sys = -1L;
        long user = -1L;
        long total = -1L;

        Cpu() {
        }

        public static Cpu readCpu(StreamInput in) throws IOException {
            Cpu cpu = new Cpu();
            cpu.readFrom(in);
            return cpu;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.percent = in.readShort();
            this.sys = in.readLong();
            this.user = in.readLong();
            this.total = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeShort(this.percent);
            out.writeLong(this.sys);
            out.writeLong(this.user);
            out.writeLong(this.total);
        }

        public short percent() {
            return this.percent;
        }

        public short getPercent() {
            return this.percent();
        }

        public TimeValue sys() {
            return new TimeValue(this.sys);
        }

        public TimeValue getSys() {
            return this.sys();
        }

        public TimeValue user() {
            return new TimeValue(this.user);
        }

        public TimeValue total() {
            return new TimeValue(this.total);
        }

        public TimeValue getTotal() {
            return this.total();
        }

        public TimeValue getUser() {
            return this.user();
        }
    }

    public static class Mem
    implements Streamable,
    Serializable {
        long totalVirtual = -1L;
        long resident = -1L;
        long share = -1L;

        Mem() {
        }

        public static Mem readMem(StreamInput in) throws IOException {
            Mem mem = new Mem();
            mem.readFrom(in);
            return mem;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.totalVirtual = in.readLong();
            this.resident = in.readLong();
            this.share = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.totalVirtual);
            out.writeLong(this.resident);
            out.writeLong(this.share);
        }

        public ByteSizeValue totalVirtual() {
            return new ByteSizeValue(this.totalVirtual);
        }

        public ByteSizeValue getTotalVirtual() {
            return this.totalVirtual();
        }

        public ByteSizeValue resident() {
            return new ByteSizeValue(this.resident);
        }

        public ByteSizeValue getResident() {
            return this.resident();
        }

        public ByteSizeValue share() {
            return new ByteSizeValue(this.share);
        }

        public ByteSizeValue getShare() {
            return this.share();
        }
    }

    static final class Fields {
        static final XContentBuilderString PROCESS = new XContentBuilderString("process");
        static final XContentBuilderString TIMESTAMP = new XContentBuilderString("timestamp");
        static final XContentBuilderString OPEN_FILE_DESCRIPTORS = new XContentBuilderString("open_file_descriptors");
        static final XContentBuilderString CPU = new XContentBuilderString("cpu");
        static final XContentBuilderString PERCENT = new XContentBuilderString("percent");
        static final XContentBuilderString SYS = new XContentBuilderString("sys");
        static final XContentBuilderString SYS_IN_MILLIS = new XContentBuilderString("sys_in_millis");
        static final XContentBuilderString USER = new XContentBuilderString("user");
        static final XContentBuilderString USER_IN_MILLIS = new XContentBuilderString("user_in_millis");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString TOTAL_IN_MILLIS = new XContentBuilderString("total_in_millis");
        static final XContentBuilderString MEM = new XContentBuilderString("mem");
        static final XContentBuilderString RESIDENT = new XContentBuilderString("resident");
        static final XContentBuilderString RESIDENT_IN_BYTES = new XContentBuilderString("resident_in_bytes");
        static final XContentBuilderString SHARE = new XContentBuilderString("share");
        static final XContentBuilderString SHARE_IN_BYTES = new XContentBuilderString("share_in_bytes");
        static final XContentBuilderString TOTAL_VIRTUAL = new XContentBuilderString("total_virtual");
        static final XContentBuilderString TOTAL_VIRTUAL_IN_BYTES = new XContentBuilderString("total_virtual_in_bytes");

        Fields() {
        }
    }
}

