/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.warmer;

import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.threadpool.ThreadPool;

public interface IndicesWarmer {
    public void addListener(Listener var1);

    public void removeListener(Listener var1);

    public static class WarmerContext {
        private final ShardId shardId;
        private final Engine.Searcher newSearcher;

        public WarmerContext(ShardId shardId, Engine.Searcher newSearcher) {
            this.shardId = shardId;
            this.newSearcher = newSearcher;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public Engine.Searcher newSearcher() {
            return this.newSearcher;
        }
    }

    public static abstract class Listener {
        public String executor() {
            return "warmer";
        }

        public abstract TerminationHandle warm(IndexShard var1, IndexMetaData var2, WarmerContext var3, ThreadPool var4);

        public static interface TerminationHandle {
            public static final TerminationHandle NO_WAIT = new TerminationHandle(){

                @Override
                public void awaitTermination() {
                }
            };

            public void awaitTermination() throws InterruptedException;
        }
    }
}

