/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.Bits;
import org.elasticsearch.search.internal.SearchContext;

public class DeleteByQueryWrappingFilter
extends Filter {
    private final Query query;
    private IndexSearcher searcher;
    private Weight weight;

    public DeleteByQueryWrappingFilter(Query query) {
        if (query == null) {
            throw new NullPointerException("Query may not be null");
        }
        this.query = query;
    }

    public final Query getQuery() {
        return this.query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocIdSet getDocIdSet(final AtomicReaderContext context, final Bits acceptDocs) throws IOException {
        SearchContext searchContext = SearchContext.current();
        if (this.weight == null) {
            assert (this.searcher == null);
            this.searcher = searchContext.searcher();
            IndexReader indexReader = SearchContext.current().searcher().getIndexReader();
            MultiReader multiReader = null;
            try {
                if (!DeleteByQueryWrappingFilter.contains(indexReader, context)) {
                    multiReader = new MultiReader(new IndexReader[]{indexReader, context.reader()}, false);
                    Similarity similarity = this.searcher.getSimilarity();
                    this.searcher = new IndexSearcher((IndexReader)new MultiReader(new IndexReader[]{indexReader, context.reader()}));
                    this.searcher.setSimilarity(similarity);
                }
                this.weight = this.searcher.createNormalizedWeight(this.query);
            }
            finally {
                if (multiReader != null) {
                    multiReader.close();
                }
            }
        }
        IndexReader indexReader = this.searcher.getIndexReader();
        if (!DeleteByQueryWrappingFilter.contains(indexReader, context)) {
            MultiReader multiReader = new MultiReader(new IndexReader[]{indexReader, context.reader()}, false);
            try {
                Similarity similarity = this.searcher.getSimilarity();
                this.searcher = new IndexSearcher((IndexReader)multiReader);
                this.searcher.setSimilarity(similarity);
                this.weight = this.searcher.createNormalizedWeight(this.query);
            }
            finally {
                multiReader.close();
            }
        }
        return new DocIdSet(){

            public DocIdSetIterator iterator() throws IOException {
                return DeleteByQueryWrappingFilter.this.weight.scorer(context, true, false, acceptDocs);
            }

            public boolean isCacheable() {
                return false;
            }
        };
    }

    public String toString() {
        return "DeleteByQueryWrappingFilter(" + this.query + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof DeleteByQueryWrappingFilter)) {
            return false;
        }
        return this.query.equals((Object)((DeleteByQueryWrappingFilter)((Object)o)).query);
    }

    public int hashCode() {
        return this.query.hashCode() ^ 0x823D64CA;
    }

    static boolean contains(IndexReader indexReader, AtomicReaderContext context) {
        for (AtomicReaderContext atomicReaderContext : indexReader.leaves()) {
            if (!context.reader().getCoreCacheKey().equals(atomicReaderContext.reader().getCoreCacheKey())) continue;
            return true;
        }
        return false;
    }
}

