/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.postingsformat;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsConsumer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.codecs.TermsConsumer;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FilterAtomicReader;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.util.BloomFilter;
import org.elasticsearch.index.store.DirectoryUtils;
import org.elasticsearch.index.store.Store;

public final class BloomFilterPostingsFormat
extends PostingsFormat {
    public static final String BLOOM_CODEC_NAME = "XBloomFilter";
    public static final int BLOOM_CODEC_VERSION = 1;
    static final String BLOOM_EXTENSION = "blm";
    private BloomFilter.Factory bloomFilterFactory = BloomFilter.Factory.DEFAULT;
    private PostingsFormat delegatePostingsFormat;

    public BloomFilterPostingsFormat(PostingsFormat delegatePostingsFormat, BloomFilter.Factory bloomFilterFactory) {
        super(BLOOM_CODEC_NAME);
        this.delegatePostingsFormat = delegatePostingsFormat;
        this.bloomFilterFactory = bloomFilterFactory;
    }

    public BloomFilterPostingsFormat() {
        super(BLOOM_CODEC_NAME);
    }

    public BloomFilteredFieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        if (this.delegatePostingsFormat == null) {
            throw new UnsupportedOperationException("Error - " + ((Object)((Object)this)).getClass().getName() + " has been constructed without a choice of PostingsFormat");
        }
        return new BloomFilteredFieldsConsumer(this.delegatePostingsFormat.fieldsConsumer(state), state, this.delegatePostingsFormat);
    }

    public BloomFilteredFieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new BloomFilteredFieldsProducer(state);
    }

    public PostingsFormat getDelegate() {
        return this.delegatePostingsFormat;
    }

    class WrappedTermsConsumer
    extends TermsConsumer {
        private TermsConsumer delegateTermsConsumer;
        private BloomFilter bloomFilter;

        public WrappedTermsConsumer(TermsConsumer termsConsumer, BloomFilter bloomFilter) {
            this.delegateTermsConsumer = termsConsumer;
            this.bloomFilter = bloomFilter;
        }

        public PostingsConsumer startTerm(BytesRef text) throws IOException {
            return this.delegateTermsConsumer.startTerm(text);
        }

        public void finishTerm(BytesRef text, TermStats stats) throws IOException {
            if (stats.docFreq > 0) {
                this.bloomFilter.put(text);
            }
            this.delegateTermsConsumer.finishTerm(text, stats);
        }

        public void finish(long sumTotalTermFreq, long sumDocFreq, int docCount) throws IOException {
            this.delegateTermsConsumer.finish(sumTotalTermFreq, sumDocFreq, docCount);
        }

        public Comparator<BytesRef> getComparator() throws IOException {
            return this.delegateTermsConsumer.getComparator();
        }
    }

    final class BloomFilteredFieldsConsumer
    extends FieldsConsumer {
        private FieldsConsumer delegateFieldsConsumer;
        private Map<FieldInfo, BloomFilter> bloomFilters = new HashMap<FieldInfo, BloomFilter>();
        private SegmentWriteState state;

        public BloomFilteredFieldsConsumer(FieldsConsumer fieldsConsumer, SegmentWriteState state, PostingsFormat delegatePostingsFormat) {
            this.delegateFieldsConsumer = fieldsConsumer;
            this.state = state;
        }

        FieldsConsumer getDelegate() {
            return this.delegateFieldsConsumer;
        }

        public TermsConsumer addField(FieldInfo field) throws IOException {
            BloomFilter bloomFilter = BloomFilterPostingsFormat.this.bloomFilterFactory.createFilter(this.state.segmentInfo.getDocCount());
            if (bloomFilter != null) {
                assert (!this.bloomFilters.containsKey(field));
                this.bloomFilters.put(field, bloomFilter);
                return new WrappedTermsConsumer(this.delegateFieldsConsumer.addField(field), bloomFilter);
            }
            return this.delegateFieldsConsumer.addField(field);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            this.delegateFieldsConsumer.close();
            ArrayList<Map.Entry<FieldInfo, BloomFilter>> nonSaturatedBlooms = new ArrayList<Map.Entry<FieldInfo, BloomFilter>>();
            for (Map.Entry<FieldInfo, BloomFilter> entry : this.bloomFilters.entrySet()) {
                nonSaturatedBlooms.add(entry);
            }
            String bloomFileName = IndexFileNames.segmentFileName((String)this.state.segmentInfo.name, (String)this.state.segmentSuffix, (String)BloomFilterPostingsFormat.BLOOM_EXTENSION);
            IndexOutput bloomOutput = null;
            try {
                bloomOutput = this.state.directory.createOutput(bloomFileName, this.state.context);
                CodecUtil.writeHeader((DataOutput)bloomOutput, (String)BloomFilterPostingsFormat.BLOOM_CODEC_NAME, (int)1);
                bloomOutput.writeString(BloomFilterPostingsFormat.this.delegatePostingsFormat.getName());
                bloomOutput.writeInt(nonSaturatedBlooms.size());
                for (Map.Entry entry : nonSaturatedBlooms) {
                    FieldInfo fieldInfo = (FieldInfo)entry.getKey();
                    BloomFilter bloomFilter = (BloomFilter)entry.getValue();
                    bloomOutput.writeInt(fieldInfo.number);
                    this.saveAppropriatelySizedBloomFilter(bloomOutput, bloomFilter, fieldInfo);
                }
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{bloomOutput});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{bloomOutput});
            this.bloomFilters.clear();
        }

        private void saveAppropriatelySizedBloomFilter(IndexOutput bloomOutput, BloomFilter bloomFilter, FieldInfo fieldInfo) throws IOException {
            BloomFilter.serilaize(bloomFilter, (DataOutput)bloomOutput);
        }
    }

    static final class BloomFilteredTermsEnum
    extends TermsEnum {
        private Terms delegateTerms;
        private TermsEnum delegateTermsEnum;
        private TermsEnum reuse;
        private BloomFilter filter;

        public BloomFilteredTermsEnum(Terms other, TermsEnum reuse, BloomFilter filter) {
            this.delegateTerms = other;
            this.reuse = reuse;
            this.filter = filter;
        }

        void reset(Terms others) {
            this.reuse = this.delegateTermsEnum;
            this.delegateTermsEnum = null;
            this.delegateTerms = others;
        }

        private TermsEnum getDelegate() throws IOException {
            if (this.delegateTermsEnum == null) {
                this.delegateTermsEnum = this.delegateTerms.iterator(this.reuse);
            }
            return this.delegateTermsEnum;
        }

        public final BytesRef next() throws IOException {
            return this.getDelegate().next();
        }

        public final Comparator<BytesRef> getComparator() {
            return this.delegateTerms.getComparator();
        }

        public final boolean seekExact(BytesRef text) throws IOException {
            if (!this.filter.mightContain(text)) {
                return false;
            }
            return this.getDelegate().seekExact(text);
        }

        public final TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            return this.getDelegate().seekCeil(text);
        }

        public final void seekExact(long ord) throws IOException {
            this.getDelegate().seekExact(ord);
        }

        public final BytesRef term() throws IOException {
            return this.getDelegate().term();
        }

        public final long ord() throws IOException {
            return this.getDelegate().ord();
        }

        public final int docFreq() throws IOException {
            return this.getDelegate().docFreq();
        }

        public final long totalTermFreq() throws IOException {
            return this.getDelegate().totalTermFreq();
        }

        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
            return this.getDelegate().docsAndPositions(liveDocs, reuse, flags);
        }

        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
            return this.getDelegate().docs(liveDocs, reuse, flags);
        }
    }

    public static final class BloomFilteredTerms
    extends FilterAtomicReader.FilterTerms {
        private BloomFilter filter;

        public BloomFilteredTerms(Terms terms, BloomFilter filter) {
            super(terms);
            this.filter = filter;
        }

        public BloomFilter getFilter() {
            return this.filter;
        }

        public TermsEnum iterator(TermsEnum reuse) throws IOException {
            if (reuse != null && reuse instanceof BloomFilteredTermsEnum) {
                BloomFilteredTermsEnum bfte = (BloomFilteredTermsEnum)reuse;
                if (bfte.filter == this.filter) {
                    bfte.reset(this.in);
                    return bfte;
                }
                reuse = bfte.reuse;
            }
            BloomFilteredTermsEnum result = new BloomFilteredTermsEnum(this.in, reuse, this.filter);
            return result;
        }
    }

    public final class BloomFilteredFieldsProducer
    extends FieldsProducer {
        private FieldsProducer delegateFieldsProducer;
        HashMap<String, BloomFilter> bloomsByFieldName = new HashMap();

        FieldsProducer getDelegate() {
            return this.delegateFieldsProducer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public BloomFilteredFieldsProducer(SegmentReadState state) throws IOException {
            String bloomFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)BloomFilterPostingsFormat.BLOOM_EXTENSION);
            IndexInput bloomIn = null;
            boolean success = false;
            try {
                bloomIn = state.directory.openInput(bloomFileName, state.context);
                CodecUtil.checkHeader((DataInput)bloomIn, (String)BloomFilterPostingsFormat.BLOOM_CODEC_NAME, (int)1, (int)1);
                PostingsFormat delegatePostingsFormat = PostingsFormat.forName((String)bloomIn.readString());
                this.delegateFieldsProducer = delegatePostingsFormat.fieldsProducer(state);
                int numBlooms = bloomIn.readInt();
                boolean load = true;
                Store.StoreDirectory storeDir = DirectoryUtils.getStoreDirectory(state.directory);
                if (storeDir != null && storeDir.codecService() != null) {
                    load = storeDir.codecService().isLoadBloomFilter();
                }
                if (load && state.context.context != IOContext.Context.MERGE) {
                    for (int i = 0; i < numBlooms; ++i) {
                        int fieldNum = bloomIn.readInt();
                        BloomFilter bloom = BloomFilter.deserialize((DataInput)bloomIn);
                        FieldInfo fieldInfo = state.fieldInfos.fieldInfo(fieldNum);
                        this.bloomsByFieldName.put(fieldInfo.name, bloom);
                    }
                }
                IOUtils.close((Closeable[])new Closeable[]{bloomIn});
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{bloomIn, this.delegateFieldsProducer});
                throw throwable;
            }
        }

        public Iterator<String> iterator() {
            return this.delegateFieldsProducer.iterator();
        }

        public void close() throws IOException {
            this.delegateFieldsProducer.close();
        }

        public Terms terms(String field) throws IOException {
            BloomFilter filter = this.bloomsByFieldName.get(field);
            if (filter == null) {
                return this.delegateFieldsProducer.terms(field);
            }
            Terms result = this.delegateFieldsProducer.terms(field);
            if (result == null) {
                return null;
            }
            return new BloomFilteredTerms(result, filter);
        }

        public int size() {
            return this.delegateFieldsProducer.size();
        }

        public long getUniqueTermCount() throws IOException {
            return this.delegateFieldsProducer.getUniqueTermCount();
        }

        public long ramBytesUsed() {
            long size = this.delegateFieldsProducer.ramBytesUsed();
            for (BloomFilter bloomFilter : this.bloomsByFieldName.values()) {
                size += bloomFilter.getSizeInBytes();
            }
            return size;
        }
    }
}

