/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.LongsRef;
import org.elasticsearch.common.primitives.Longs;

public final class SlicedLongList
extends AbstractList<Long>
implements RandomAccess {
    public static final SlicedLongList EMPTY = new SlicedLongList(LongsRef.EMPTY_LONGS, 0, 0);
    public long[] values;
    public int offset;
    public int length;

    public SlicedLongList(int capacity) {
        this(new long[capacity], 0, capacity);
    }

    public SlicedLongList(long[] values, int offset, int length) {
        this.values = values;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Long get(int index) {
        assert (index < this.size());
        return this.values[this.offset + index];
    }

    @Override
    public boolean contains(Object target) {
        return target instanceof Long && SlicedLongList.indexOf(this.values, (Long)target, this.offset, this.offset + this.length) != -1;
    }

    @Override
    public int indexOf(Object target) {
        int i;
        if (target instanceof Long && (i = SlicedLongList.indexOf(this.values, (Long)target, this.offset, this.offset + this.length)) >= 0) {
            return i - this.offset;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object target) {
        int i;
        if (target instanceof Long && (i = SlicedLongList.lastIndexOf(this.values, (Long)target, this.offset, this.offset + this.length)) >= 0) {
            return i - this.offset;
        }
        return -1;
    }

    @Override
    public Long set(int index, Long element) {
        throw new UnsupportedOperationException("modifying list opertations are not implemented");
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SlicedLongList) {
            SlicedLongList that = (SlicedLongList)object;
            int size = this.size();
            if (that.size() != size) {
                return false;
            }
            for (int i = 0; i < size; ++i) {
                if (this.values[this.offset + i] == that.values[that.offset + i]) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.length; ++i) {
            result = 31 * result + Longs.hashCode(this.values[this.offset + i]);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(this.size() * 10);
        builder.append('[');
        if (this.length > 0) {
            builder.append(this.values[this.offset]);
            for (int i = 1; i < this.length; ++i) {
                builder.append(", ").append(this.values[this.offset + i]);
            }
        }
        return builder.append(']').toString();
    }

    private static int indexOf(long[] array, long target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    private static int lastIndexOf(long[] array, long target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public void grow(int newLength) {
        assert (this.offset == 0);
        this.values = ArrayUtil.grow((long[])this.values, (int)newLength);
    }
}

