/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.routing.MutableShardRouting;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class NodeVersionAllocationDecider
extends AllocationDecider {
    @Inject
    public NodeVersionAllocationDecider(Settings settings) {
        super(settings);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        String sourceNodeId = shardRouting.currentNodeId();
        if (sourceNodeId == null) {
            if (shardRouting.primary()) {
                return allocation.decision(Decision.YES, "primary shard can be allocated anywhere", new Object[0]);
            }
            MutableShardRouting primary = allocation.routingNodes().activePrimary(shardRouting);
            if (primary == null) {
                return allocation.decision(Decision.YES, "no active primary shard yet", new Object[0]);
            }
            sourceNodeId = primary.currentNodeId();
        }
        return this.isVersionCompatible(allocation.routingNodes(), sourceNodeId, node, allocation);
    }

    private Decision isVersionCompatible(RoutingNodes routingNodes, String sourceNodeId, RoutingNode target, RoutingAllocation allocation) {
        RoutingNode source = routingNodes.node(sourceNodeId);
        if (target.node().version().onOrAfter(source.node().version())) {
            return allocation.decision(Decision.YES, "target node version [%s] is same or newer than source node version [%s]", target.node().version(), source.node().version());
        }
        return allocation.decision(Decision.NO, "target node version [%s] is older than source node version [%s]", target.node().version(), source.node().version());
    }
}

