/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class SearchRequest
extends ActionRequest<SearchRequest> {
    private static final XContentType contentType = Requests.CONTENT_TYPE;
    private SearchType searchType = SearchType.DEFAULT;
    private String[] indices;
    @Nullable
    private String routing;
    @Nullable
    private String preference;
    private BytesReference source;
    private boolean sourceUnsafe;
    private BytesReference extraSource;
    private boolean extraSourceUnsafe;
    private Scroll scroll;
    private String[] types = Strings.EMPTY_ARRAY;
    private SearchOperationThreading operationThreading = SearchOperationThreading.THREAD_PER_SHARD;
    private IndicesOptions indicesOptions = IndicesOptions.strict();

    public SearchRequest() {
    }

    public SearchRequest(String ... indices) {
        this.indices(indices);
    }

    public SearchRequest(String[] indices, byte[] source) {
        this.indices(indices);
        this.source = new BytesArray(source);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        return validationException;
    }

    public void beforeStart() {
        if (this.source != null && this.sourceUnsafe) {
            this.source = this.source.copyBytesArray();
            this.sourceUnsafe = false;
        }
        if (this.extraSource != null && this.extraSourceUnsafe) {
            this.extraSource = this.extraSource.copyBytesArray();
            this.extraSourceUnsafe = false;
        }
    }

    public void beforeLocalFork() {
    }

    public SearchRequest indices(String ... indices) {
        if (indices == null) {
            throw new ElasticsearchIllegalArgumentException("indices must not be null");
        }
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] != null) continue;
            throw new ElasticsearchIllegalArgumentException("indices[" + i + "] must not be null");
        }
        this.indices = indices;
        return this;
    }

    public SearchOperationThreading operationThreading() {
        return this.operationThreading;
    }

    public SearchRequest operationThreading(SearchOperationThreading operationThreading) {
        this.operationThreading = operationThreading;
        return this;
    }

    public SearchRequest operationThreading(String operationThreading) {
        return this.operationThreading(SearchOperationThreading.fromString(operationThreading, this.operationThreading));
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public SearchRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public SearchRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public SearchRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public SearchRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public SearchRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public SearchRequest searchType(SearchType searchType) {
        this.searchType = searchType;
        return this;
    }

    public SearchRequest searchType(String searchType) throws ElasticsearchIllegalArgumentException {
        return this.searchType(SearchType.fromString(searchType));
    }

    public SearchRequest source(SearchSourceBuilder sourceBuilder) {
        this.source = sourceBuilder.buildAsBytes(contentType);
        this.sourceUnsafe = false;
        return this;
    }

    public SearchRequest source(String source) {
        this.source = new BytesArray(source);
        this.sourceUnsafe = false;
        return this;
    }

    public SearchRequest source(Map source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(source);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public SearchRequest source(XContentBuilder builder) {
        this.source = builder.bytes();
        this.sourceUnsafe = false;
        return this;
    }

    public SearchRequest source(byte[] source) {
        return this.source(source, 0, source.length, false);
    }

    public SearchRequest source(byte[] source, int offset, int length) {
        return this.source(source, offset, length, false);
    }

    public SearchRequest source(byte[] source, int offset, int length, boolean unsafe) {
        return this.source(new BytesArray(source, offset, length), unsafe);
    }

    public SearchRequest source(BytesReference source, boolean unsafe) {
        this.source = source;
        this.sourceUnsafe = unsafe;
        return this;
    }

    public BytesReference source() {
        return this.source;
    }

    public SearchRequest extraSource(SearchSourceBuilder sourceBuilder) {
        if (sourceBuilder == null) {
            this.extraSource = null;
            return this;
        }
        this.extraSource = sourceBuilder.buildAsBytes(contentType);
        this.extraSourceUnsafe = false;
        return this;
    }

    public SearchRequest extraSource(Map extraSource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(extraSource);
            return this.extraSource(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + this.source + "]", e);
        }
    }

    public SearchRequest extraSource(XContentBuilder builder) {
        this.extraSource = builder.bytes();
        this.extraSourceUnsafe = false;
        return this;
    }

    public SearchRequest extraSource(String source) {
        this.extraSource = new BytesArray(source);
        this.extraSourceUnsafe = false;
        return this;
    }

    public SearchRequest extraSource(byte[] source) {
        return this.extraSource(source, 0, source.length, false);
    }

    public SearchRequest extraSource(byte[] source, int offset, int length) {
        return this.extraSource(source, offset, length, false);
    }

    public SearchRequest extraSource(byte[] source, int offset, int length, boolean unsafe) {
        return this.extraSource(new BytesArray(source, offset, length), unsafe);
    }

    public SearchRequest extraSource(BytesReference source, boolean unsafe) {
        this.extraSource = source;
        this.extraSourceUnsafe = unsafe;
        return this;
    }

    public BytesReference extraSource() {
        return this.extraSource;
    }

    public SearchType searchType() {
        return this.searchType;
    }

    public String[] indices() {
        return this.indices;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public SearchRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    public SearchRequest scroll(TimeValue keepAlive) {
        return this.scroll(new Scroll(keepAlive));
    }

    public SearchRequest scroll(String keepAlive) {
        return this.scroll(new Scroll(TimeValue.parseTimeValue(keepAlive, null)));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.operationThreading = SearchOperationThreading.fromId(in.readByte());
        this.searchType = SearchType.fromId(in.readByte());
        this.indices = new String[in.readVInt()];
        for (int i = 0; i < this.indices.length; ++i) {
            this.indices[i] = in.readString();
        }
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        if (in.readBoolean()) {
            this.scroll = Scroll.readScroll(in);
        }
        this.sourceUnsafe = false;
        this.source = in.readBytesReference();
        this.extraSourceUnsafe = false;
        this.extraSource = in.readBytesReference();
        this.types = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.operationThreading.id());
        out.writeByte(this.searchType.id());
        out.writeVInt(this.indices.length);
        for (String index : this.indices) {
            out.writeString(index);
        }
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        if (this.scroll == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.scroll.writeTo(out);
        }
        out.writeBytesReference(this.source);
        out.writeBytesReference(this.extraSource);
        out.writeStringArray(this.types);
        this.indicesOptions.writeIndicesOptions(out);
    }
}

