/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.index.query.FilterBuilder;

public class IndicesAliasesRequest
extends AcknowledgedRequest<IndicesAliasesRequest> {
    private List<AliasActions> allAliasActions = Lists.newArrayList();
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, false, true, false);

    public IndicesAliasesRequest addAlias(String alias, String ... indices) {
        this.addAliasAction(new AliasActions(AliasAction.Type.ADD, indices, alias));
        return this;
    }

    public void addAliasAction(AliasActions aliasAction) {
        this.allAliasActions.add(aliasAction);
    }

    public IndicesAliasesRequest addAliasAction(AliasAction action) {
        this.addAliasAction(new AliasActions(action));
        return this;
    }

    public IndicesAliasesRequest addAlias(String alias, Map<String, Object> filter, String ... indices) {
        this.addAliasAction(new AliasActions(AliasAction.Type.ADD, indices, alias).filter(filter));
        return this;
    }

    public IndicesAliasesRequest addAlias(String alias, FilterBuilder filterBuilder, String ... indices) {
        this.addAliasAction(new AliasActions(AliasAction.Type.ADD, indices, alias).filter(filterBuilder));
        return this;
    }

    public IndicesAliasesRequest removeAlias(String[] indices, String ... aliases) {
        this.addAliasAction(new AliasActions(AliasAction.Type.REMOVE, indices, aliases));
        return this;
    }

    public IndicesAliasesRequest removeAlias(String index, String ... aliases) {
        this.addAliasAction(new AliasActions(AliasAction.Type.REMOVE, index, aliases));
        return this;
    }

    List<AliasActions> aliasActions() {
        return this.allAliasActions;
    }

    public List<AliasActions> getAliasActions() {
        return this.aliasActions();
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.allAliasActions.isEmpty()) {
            return ValidateActions.addValidationError("Must specify at least one alias action", validationException);
        }
        for (AliasActions aliasAction : this.allAliasActions) {
            if (aliasAction.actionType() == AliasAction.Type.ADD) {
                if (aliasAction.aliases.length != 1) {
                    validationException = ValidateActions.addValidationError("Alias action [" + aliasAction.actionType().name().toLowerCase(Locale.ENGLISH) + "] requires exactly one [alias] to be set", validationException);
                }
                if (!Strings.hasText(aliasAction.aliases[0])) {
                    validationException = ValidateActions.addValidationError("Alias action [" + aliasAction.actionType().name().toLowerCase(Locale.ENGLISH) + "] requires an [alias] to be set", validationException);
                }
            } else {
                if (aliasAction.aliases.length == 0) {
                    validationException = ValidateActions.addValidationError("Alias action [" + aliasAction.actionType().name().toLowerCase(Locale.ENGLISH) + "]: aliases may not be empty", validationException);
                }
                for (String alias : aliasAction.aliases) {
                    if (Strings.hasText(alias)) continue;
                    validationException = ValidateActions.addValidationError("Alias action [" + aliasAction.actionType().name().toLowerCase(Locale.ENGLISH) + "]: [alias] may not be empty string", validationException);
                }
                if (CollectionUtils.isEmpty(aliasAction.indices)) {
                    validationException = ValidateActions.addValidationError("Alias action [" + aliasAction.actionType().name().toLowerCase(Locale.ENGLISH) + "]: indices may not be empty", validationException);
                }
            }
            if (CollectionUtils.isEmpty(aliasAction.indices)) continue;
            for (String index : aliasAction.indices) {
                if (Strings.hasText(index)) continue;
                validationException = ValidateActions.addValidationError("Alias action [" + aliasAction.actionType().name().toLowerCase(Locale.ENGLISH) + "]: [index] may not be empty string", validationException);
            }
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            this.allAliasActions.add(this.readAliasActions(in));
        }
        this.readTimeout(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.allAliasActions.size());
        for (AliasActions aliasAction : this.allAliasActions) {
            aliasAction.writeTo(out);
        }
        this.writeTimeout(out);
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    private AliasActions readAliasActions(StreamInput in) throws IOException {
        AliasActions actions = new AliasActions();
        return actions.readFrom(in);
    }

    public static class AliasActions {
        private String[] indices = Strings.EMPTY_ARRAY;
        private String[] aliases = Strings.EMPTY_ARRAY;
        private AliasAction aliasAction;

        public AliasActions(AliasAction.Type type, String[] indices, String[] aliases) {
            this.aliasAction = new AliasAction(type);
            this.indices(indices);
            this.aliases(aliases);
        }

        public AliasActions(AliasAction.Type type, String index, String alias) {
            this.aliasAction = new AliasAction(type);
            this.indices(index);
            this.aliases(alias);
        }

        AliasActions(AliasAction.Type type, String[] index, String alias) {
            this.aliasAction = new AliasAction(type);
            this.indices(index);
            this.aliases(alias);
        }

        public AliasActions(AliasAction action) {
            this.aliasAction = action;
            this.indices(action.index());
            this.aliases(action.alias());
        }

        public AliasActions(AliasAction.Type type, String index, String[] aliases) {
            this.aliasAction = new AliasAction(type);
            this.indices(index);
            this.aliases(aliases);
        }

        public AliasActions() {
        }

        public AliasActions filter(Map<String, Object> filter) {
            this.aliasAction.filter(filter);
            return this;
        }

        public AliasActions filter(FilterBuilder filter) {
            this.aliasAction.filter(filter);
            return this;
        }

        public AliasAction.Type actionType() {
            return this.aliasAction.actionType();
        }

        public void routing(String routing) {
            this.aliasAction.routing(routing);
        }

        public void searchRouting(String searchRouting) {
            this.aliasAction.searchRouting(searchRouting);
        }

        public void indexRouting(String indexRouting) {
            this.aliasAction.indexRouting(indexRouting);
        }

        public AliasActions filter(String filter) {
            this.aliasAction.filter(filter);
            return this;
        }

        public void indices(String ... indices) {
            ArrayList<String> finalIndices = new ArrayList<String>();
            for (String index : indices) {
                if (index == null) continue;
                finalIndices.add(index);
            }
            this.indices = finalIndices.toArray(new String[finalIndices.size()]);
        }

        public void aliases(String ... aliases) {
            this.aliases = aliases;
        }

        public String[] aliases() {
            return this.aliases;
        }

        public String[] indices() {
            return this.indices;
        }

        public AliasAction aliasAction() {
            return this.aliasAction;
        }

        public String[] concreteAliases(MetaData metaData, String concreteIndex) {
            if (this.aliasAction.actionType() == AliasAction.Type.REMOVE) {
                String[] indexAsArray = new String[]{concreteIndex};
                ImmutableOpenMap<String, ImmutableList<AliasMetaData>> aliasMetaData = metaData.findAliases(this.aliases, indexAsArray);
                ArrayList<String> finalAliases = new ArrayList<String>();
                for (ObjectCursor<ImmutableList<AliasMetaData>> objectCursor : aliasMetaData.values()) {
                    for (AliasMetaData aliasMeta : (ImmutableList)objectCursor.value) {
                        finalAliases.add(aliasMeta.alias());
                    }
                }
                return finalAliases.toArray(new String[finalAliases.size()]);
            }
            return this.aliases;
        }

        public AliasActions readFrom(StreamInput in) throws IOException {
            this.indices = in.readStringArray();
            this.aliases = in.readStringArray();
            this.aliasAction = AliasAction.readAliasAction(in);
            return this;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringArray(this.indices);
            out.writeStringArray(this.aliases);
            this.aliasAction.writeTo(out);
        }
    }
}

