/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.reroute;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommand;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommands;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;

public class ClusterRerouteRequest
extends AcknowledgedRequest<ClusterRerouteRequest> {
    AllocationCommands commands = new AllocationCommands(new AllocationCommand[0]);
    boolean dryRun;

    public ClusterRerouteRequest add(AllocationCommand ... commands) {
        this.commands.add(commands);
        return this;
    }

    public ClusterRerouteRequest dryRun(boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public boolean dryRun() {
        return this.dryRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterRerouteRequest source(BytesReference source) throws Exception {
        XContentParser parser = XContentHelper.createParser(source);
        try {
            XContentParser.Token token;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if ("commands".equals(currentFieldName)) {
                        this.commands = AllocationCommands.fromXContent(parser);
                        continue;
                    }
                    throw new ElasticsearchParseException("failed to parse reroute request, got start array with wrong field name [" + currentFieldName + "]");
                }
                if (!token.isValue()) continue;
                if ("dry_run".equals(currentFieldName) || "dryRun".equals(currentFieldName)) {
                    this.dryRun = parser.booleanValue();
                    continue;
                }
                throw new ElasticsearchParseException("failed to parse reroute request, got value with wrong field name [" + currentFieldName + "]");
            }
        }
        finally {
            parser.close();
        }
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.commands = AllocationCommands.readFrom(in);
        this.dryRun = in.readBoolean();
        this.readTimeout(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        AllocationCommands.writeTo(this.commands, out);
        out.writeBoolean(this.dryRun);
        this.writeTimeout(out);
    }
}

