/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.repositories.get;

import java.io.IOException;
import java.util.Iterator;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.ImmutableSettings;

public class GetRepositoriesResponse
extends ActionResponse
implements Iterable<RepositoryMetaData> {
    private ImmutableList<RepositoryMetaData> repositories = ImmutableList.of();

    GetRepositoriesResponse() {
    }

    GetRepositoriesResponse(ImmutableList<RepositoryMetaData> repositories) {
        this.repositories = repositories;
    }

    public ImmutableList<RepositoryMetaData> repositories() {
        return this.repositories;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        ImmutableList.Builder repositoryListBuilder = ImmutableList.builder();
        for (int j = 0; j < size; ++j) {
            repositoryListBuilder.add(new RepositoryMetaData(in.readString(), in.readString(), ImmutableSettings.readSettingsFromStream(in)));
        }
        this.repositories = repositoryListBuilder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.repositories.size());
        for (RepositoryMetaData repository : this.repositories) {
            out.writeString(repository.name());
            out.writeString(repository.type());
            ImmutableSettings.writeSettingsToStream(repository.settings(), out);
        }
    }

    @Override
    public Iterator<RepositoryMetaData> iterator() {
        return this.repositories.iterator();
    }
}

