/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.FixedBitSet;

class TermsIncludingScoreQuery
extends Query {
    final String field;
    final boolean multipleValuesPerDocument;
    final BytesRefHash terms;
    final float[] scores;
    final int[] ords;
    final Query originalQuery;
    final Query unwrittenOriginalQuery;

    TermsIncludingScoreQuery(String field, boolean multipleValuesPerDocument, BytesRefHash terms, float[] scores, Query originalQuery) {
        this.field = field;
        this.multipleValuesPerDocument = multipleValuesPerDocument;
        this.terms = terms;
        this.scores = scores;
        this.originalQuery = originalQuery;
        this.ords = terms.sort(BytesRef.getUTF8SortedAsUnicodeComparator());
        this.unwrittenOriginalQuery = originalQuery;
    }

    private TermsIncludingScoreQuery(String field, boolean multipleValuesPerDocument, BytesRefHash terms, float[] scores, int[] ords, Query originalQuery, Query unwrittenOriginalQuery) {
        this.field = field;
        this.multipleValuesPerDocument = multipleValuesPerDocument;
        this.terms = terms;
        this.scores = scores;
        this.originalQuery = originalQuery;
        this.ords = ords;
        this.unwrittenOriginalQuery = unwrittenOriginalQuery;
    }

    public String toString(String string) {
        return String.format(Locale.ROOT, "TermsIncludingScoreQuery{field=%s;originalQuery=%s}", this.field, this.unwrittenOriginalQuery);
    }

    public void extractTerms(Set<Term> terms) {
        this.originalQuery.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query originalQueryRewrite = this.originalQuery.rewrite(reader);
        if (originalQueryRewrite != this.originalQuery) {
            TermsIncludingScoreQuery rewritten = new TermsIncludingScoreQuery(this.field, this.multipleValuesPerDocument, this.terms, this.scores, this.ords, originalQueryRewrite, this.originalQuery);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TermsIncludingScoreQuery other = (TermsIncludingScoreQuery)((Object)obj);
        if (!this.field.equals(other.field)) {
            return false;
        }
        return this.unwrittenOriginalQuery.equals((Object)other.unwrittenOriginalQuery);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result += 31 * this.field.hashCode();
        return result += 31 * this.unwrittenOriginalQuery.hashCode();
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        final Weight originalWeight = this.originalQuery.createWeight(searcher);
        return new Weight(){
            private TermsEnum segmentTermsEnum;

            public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
                SVInnerScorer scorer = (SVInnerScorer)this.scorer(context, false, false, context.reader().getLiveDocs());
                if (scorer != null && scorer.advanceForExplainOnly(doc) == doc) {
                    return scorer.explain();
                }
                return new ComplexExplanation(false, 0.0f, "Not a match");
            }

            public Query getQuery() {
                return TermsIncludingScoreQuery.this;
            }

            public float getValueForNormalization() throws IOException {
                return originalWeight.getValueForNormalization() * TermsIncludingScoreQuery.this.getBoost() * TermsIncludingScoreQuery.this.getBoost();
            }

            public void normalize(float norm, float topLevelBoost) {
                originalWeight.normalize(norm, topLevelBoost * TermsIncludingScoreQuery.this.getBoost());
            }

            public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
                Terms terms = context.reader().terms(TermsIncludingScoreQuery.this.field);
                if (terms == null) {
                    return null;
                }
                long cost = (long)context.reader().maxDoc() * terms.size();
                this.segmentTermsEnum = terms.iterator(this.segmentTermsEnum);
                if (scoreDocsInOrder) {
                    if (TermsIncludingScoreQuery.this.multipleValuesPerDocument) {
                        return new MVInOrderScorer(this, acceptDocs, this.segmentTermsEnum, context.reader().maxDoc(), cost);
                    }
                    return new SVInOrderScorer(this, acceptDocs, this.segmentTermsEnum, context.reader().maxDoc(), cost);
                }
                if (TermsIncludingScoreQuery.this.multipleValuesPerDocument) {
                    return new MVInnerScorer(this, acceptDocs, this.segmentTermsEnum, context.reader().maxDoc(), cost);
                }
                return new SVInnerScorer(this, acceptDocs, this.segmentTermsEnum, cost);
            }
        };
    }

    class MVInOrderScorer
    extends SVInOrderScorer {
        MVInOrderScorer(Weight weight, Bits acceptDocs, TermsEnum termsEnum, int maxDoc, long cost) throws IOException {
            super(weight, acceptDocs, termsEnum, maxDoc, cost);
        }

        @Override
        protected void fillDocsAndScores(FixedBitSet matchingDocs, Bits acceptDocs, TermsEnum termsEnum) throws IOException {
            BytesRef spare = new BytesRef();
            DocsEnum docsEnum = null;
            for (int i = 0; i < TermsIncludingScoreQuery.this.terms.size(); ++i) {
                if (!termsEnum.seekExact(TermsIncludingScoreQuery.this.terms.get(TermsIncludingScoreQuery.this.ords[i], spare))) continue;
                docsEnum = termsEnum.docs(acceptDocs, docsEnum, 0);
                float score = TermsIncludingScoreQuery.this.scores[TermsIncludingScoreQuery.this.ords[i]];
                int doc = docsEnum.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (!matchingDocs.get(doc)) {
                        this.scores[doc] = score;
                        matchingDocs.set(doc);
                    }
                    doc = docsEnum.nextDoc();
                }
            }
        }
    }

    class SVInOrderScorer
    extends Scorer {
        final DocIdSetIterator matchingDocsIterator;
        final float[] scores;
        final long cost;
        int currentDoc;

        SVInOrderScorer(Weight weight, Bits acceptDocs, TermsEnum termsEnum, int maxDoc, long cost) throws IOException {
            super(weight);
            this.currentDoc = -1;
            FixedBitSet matchingDocs = new FixedBitSet(maxDoc);
            this.scores = new float[maxDoc];
            this.fillDocsAndScores(matchingDocs, acceptDocs, termsEnum);
            this.matchingDocsIterator = matchingDocs.iterator();
            this.cost = cost;
        }

        protected void fillDocsAndScores(FixedBitSet matchingDocs, Bits acceptDocs, TermsEnum termsEnum) throws IOException {
            BytesRef spare = new BytesRef();
            DocsEnum docsEnum = null;
            for (int i = 0; i < TermsIncludingScoreQuery.this.terms.size(); ++i) {
                if (!termsEnum.seekExact(TermsIncludingScoreQuery.this.terms.get(TermsIncludingScoreQuery.this.ords[i], spare))) continue;
                docsEnum = termsEnum.docs(acceptDocs, docsEnum, 0);
                float score = TermsIncludingScoreQuery.this.scores[TermsIncludingScoreQuery.this.ords[i]];
                int doc = docsEnum.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    matchingDocs.set(doc);
                    this.scores[doc] = score;
                    doc = docsEnum.nextDoc();
                }
            }
        }

        public float score() throws IOException {
            return this.scores[this.currentDoc];
        }

        public int freq() throws IOException {
            return 1;
        }

        public int docID() {
            return this.currentDoc;
        }

        public int nextDoc() throws IOException {
            this.currentDoc = this.matchingDocsIterator.nextDoc();
            return this.currentDoc;
        }

        public int advance(int target) throws IOException {
            this.currentDoc = this.matchingDocsIterator.advance(target);
            return this.currentDoc;
        }

        public long cost() {
            return this.cost;
        }
    }

    class MVInnerScorer
    extends SVInnerScorer {
        final FixedBitSet alreadyEmittedDocs;

        MVInnerScorer(Weight weight, Bits acceptDocs, TermsEnum termsEnum, int maxDoc, long cost) {
            super(weight, acceptDocs, termsEnum, cost);
            this.alreadyEmittedDocs = new FixedBitSet(maxDoc);
        }

        @Override
        protected int docsEnumNextDoc() throws IOException {
            int docId;
            do {
                if ((docId = this.docsEnum.nextDoc()) != Integer.MAX_VALUE) continue;
                return docId;
            } while (this.alreadyEmittedDocs.getAndSet(docId));
            return docId;
        }
    }

    class SVInnerScorer
    extends Scorer {
        final BytesRef spare;
        final Bits acceptDocs;
        final TermsEnum termsEnum;
        final long cost;
        int upto;
        DocsEnum docsEnum;
        DocsEnum reuse;
        int scoreUpto;
        int doc;

        SVInnerScorer(Weight weight, Bits acceptDocs, TermsEnum termsEnum, long cost) {
            super(weight);
            this.spare = new BytesRef();
            this.acceptDocs = acceptDocs;
            this.termsEnum = termsEnum;
            this.cost = cost;
            this.doc = -1;
        }

        public void score(Collector collector) throws IOException {
            collector.setScorer((Scorer)this);
            int doc = this.nextDocOutOfOrder();
            while (doc != Integer.MAX_VALUE) {
                collector.collect(doc);
                doc = this.nextDocOutOfOrder();
            }
        }

        public float score() throws IOException {
            return TermsIncludingScoreQuery.this.scores[TermsIncludingScoreQuery.this.ords[this.scoreUpto]];
        }

        Explanation explain() throws IOException {
            return new ComplexExplanation(true, this.score(), "Score based on join value " + this.termsEnum.term().utf8ToString());
        }

        public int docID() {
            return this.doc;
        }

        int nextDocOutOfOrder() throws IOException {
            while (true) {
                if (this.docsEnum != null) {
                    int docId = this.docsEnumNextDoc();
                    if (docId == Integer.MAX_VALUE) {
                        this.docsEnum = null;
                    } else {
                        this.doc = docId;
                        return this.doc;
                    }
                }
                if (this.upto == TermsIncludingScoreQuery.this.terms.size()) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                this.scoreUpto = this.upto;
                if (!this.termsEnum.seekExact(TermsIncludingScoreQuery.this.terms.get(TermsIncludingScoreQuery.this.ords[this.upto++], this.spare))) continue;
                this.docsEnum = this.reuse = this.termsEnum.docs(this.acceptDocs, this.reuse, 0);
            }
        }

        protected int docsEnumNextDoc() throws IOException {
            return this.docsEnum.nextDoc();
        }

        public int nextDoc() throws IOException {
            throw new UnsupportedOperationException("nextDoc() isn't supported because doc ids are emitted out of order");
        }

        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException("advance() isn't supported because doc ids are emitted out of order");
        }

        private int advanceForExplainOnly(int target) throws IOException {
            int docId;
            do {
                if ((docId = this.nextDocOutOfOrder()) < target) {
                    int tempDocId = this.docsEnum.advance(target);
                    if (tempDocId == target) {
                        docId = tempDocId;
                        break;
                    }
                } else if (docId == target) break;
                this.docsEnum = null;
            } while (docId != Integer.MAX_VALUE);
            return docId;
        }

        public int freq() {
            return 1;
        }

        public long cost() {
            return this.cost;
        }
    }
}

