/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.collection_codegen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.util.SelectorUtils;

public class CodeGenerator
extends AbstractMojo {
    private static final String[] NO_STRINGS = new String[]{null};
    private static final Charset UTF8 = Charset.forName("utf-8");
    private final Map<String, String> typeToObjectTypeMap = new HashMap<String, String>();
    private String testTemplateRoot;
    private File testOutputDirectory;
    private String sourceTemplateRoot;
    private File outputDirectory;
    private File doNotReplaceMainDirectory;
    private File doNotReplaceTestDirectory;
    private String[] mainExcludes;
    private String[] testExcludes;
    private String valueTypes;
    private String keyTypes;
    private MavenProject project;
    private VelocityEngine testVelocityEngine;
    private final FileSetManager fileSetManager;
    private VelocityEngine mainVelocityEngine;

    public CodeGenerator() {
        this.typeToObjectTypeMap.put("boolean", "Boolean");
        this.typeToObjectTypeMap.put("byte", "Byte");
        this.typeToObjectTypeMap.put("char", "Character");
        this.typeToObjectTypeMap.put("int", "Integer");
        this.typeToObjectTypeMap.put("short", "Short");
        this.typeToObjectTypeMap.put("long", "Long");
        this.typeToObjectTypeMap.put("float", "Float");
        this.typeToObjectTypeMap.put("double", "Double");
        this.fileSetManager = new FileSetManager(this.getLog());
    }

    public void execute() throws MojoExecutionException {
        File f = this.outputDirectory;
        if (!f.exists()) {
            f.mkdirs();
        }
        if (this.testOutputDirectory != null && !this.testOutputDirectory.exists()) {
            this.testOutputDirectory.mkdirs();
        }
        this.initializeVelocity();
        if (this.sourceTemplateRoot != null) {
            this.runGeneration(this.sourceTemplateRoot, this.mainVelocityEngine, this.outputDirectory, this.doNotReplaceMainDirectory, this.mainExcludes);
        }
        if (this.testTemplateRoot != null) {
            this.runGeneration(this.testTemplateRoot, this.testVelocityEngine, this.testOutputDirectory, this.doNotReplaceTestDirectory, this.testExcludes);
        }
        if (this.project != null && this.outputDirectory != null && this.outputDirectory.exists()) {
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
        if (this.project != null && this.testOutputDirectory != null && this.testOutputDirectory.exists()) {
            this.project.addTestCompileSourceRoot(this.testOutputDirectory.getAbsolutePath());
        }
    }

    private void initializeVelocity() throws MojoExecutionException {
        this.mainVelocityEngine = new VelocityEngine();
        this.mainVelocityEngine.setProperty("file.resource.loader.path", (Object)this.sourceTemplateRoot);
        if (this.testTemplateRoot != null) {
            this.testVelocityEngine = new VelocityEngine();
            this.testVelocityEngine.setProperty("file.resource.loader.path", (Object)this.testTemplateRoot);
        }
        try {
            this.mainVelocityEngine.init();
            if (this.testVelocityEngine != null) {
                this.testVelocityEngine.init();
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to initialize velocity", e);
        }
    }

    private void runGeneration(String thisSourceRoot, VelocityEngine engine, File thisOutputDirectory, File thisDoNotReplaceDirectory, String[] excludes) throws MojoExecutionException {
        String[] includedFiles;
        FileSet fileSet = new FileSet();
        fileSet.setDirectory(thisSourceRoot);
        ArrayList<String> includes = new ArrayList<String>();
        includes.add("**/*.java.t");
        fileSet.setIncludes(includes);
        for (String template : includedFiles = this.fileSetManager.getIncludedFiles(fileSet)) {
            File templateFile = new File(thisSourceRoot, template);
            String subpath = templateFile.getParentFile().getPath().substring(fileSet.getDirectory().length());
            thisOutputDirectory.mkdirs();
            File thisDoNotReplaceFull = new File(thisDoNotReplaceDirectory, subpath);
            this.processOneTemplate(engine, template, thisOutputDirectory, thisDoNotReplaceFull, subpath.substring(1), excludes);
        }
    }

    private void processOneTemplate(VelocityEngine engine, String template, File thisOutputDirectory, File thisDoNotReplaceDirectory, String packageDirectory, String[] excludes) throws MojoExecutionException {
        boolean hasKey = template.contains("KeyType");
        boolean hasValue = template.contains("ValueType");
        String[] keys = hasKey ? this.keyTypes.split(",") : NO_STRINGS;
        String[] values = hasValue ? this.valueTypes.split(",") : NO_STRINGS;
        for (String key : keys) {
            for (String value : values) {
                this.expandOneTemplate(engine, template, thisOutputDirectory, thisDoNotReplaceDirectory, excludes, packageDirectory, key, value);
            }
        }
    }

    private void expandOneTemplate(VelocityEngine engine, String templateName, File thisOutputDirectory, File thisDoNotReplaceDirectory, String[] excludes, String packageDirectory, String key, String value) throws MojoExecutionException {
        File dnrf;
        boolean floating;
        String outputName = templateName.replaceFirst("\\.java\\.t$", ".java");
        VelocityContext vc = new VelocityContext();
        if (key != null) {
            String keyCap = key.toUpperCase().charAt(0) + key.substring(1);
            outputName = outputName.replaceAll("KeyType", keyCap);
            vc.put("keyType", (Object)key);
            vc.put("keyTypeCap", (Object)keyCap);
            vc.put("keyObjectType", (Object)this.typeToObjectTypeMap.get(key));
            floating = "float".equals(key) || "double".equals(key);
            vc.put("keyTypeFloating", (Object)(floating ? "true" : "false"));
        }
        if (value != null) {
            String valueCap = value.toUpperCase().charAt(0) + value.substring(1);
            outputName = outputName.replaceAll("ValueType", valueCap);
            vc.put("valueType", (Object)value);
            vc.put("valueTypeCap", (Object)valueCap);
            vc.put("valueObjectType", (Object)this.typeToObjectTypeMap.get(value));
            floating = "float".equals(value) || "double".equals(value);
            vc.put("valueTypeFloating", (Object)(floating ? "true" : "false"));
        }
        File outputFile = new File(thisOutputDirectory, outputName);
        if (thisDoNotReplaceDirectory != null && (dnrf = new File(thisDoNotReplaceDirectory, outputName)).exists()) {
            this.getLog().info((CharSequence)("Deferring to " + dnrf.getPath()));
            return;
        }
        if (excludes != null) {
            for (String exclude : excludes) {
                File excludeFile = new File(packageDirectory, outputName);
                if (!SelectorUtils.matchPath((String)exclude, (String)excludeFile.getPath())) continue;
                this.getLog().info((CharSequence)("Excluding " + excludeFile.getPath()));
                return;
            }
        }
        try {
            Template template = engine.getTemplate(templateName);
            this.getLog().info((CharSequence)("Writing to " + outputFile.getAbsolutePath()));
            outputFile.getParentFile().mkdirs();
            FileOutputStream fos = new FileOutputStream(outputFile);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, UTF8);
            template.merge((Context)vc, (Writer)osw);
            osw.close();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Failed to expand template", e);
        }
    }
}

