/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.io.ShapeReader;
import org.locationtech.spatial4j.io.ShapeWriter;
import org.locationtech.spatial4j.shape.Shape;

public class ShapeFormatTest {
    public Shape testReadAndWriteTheSame(Shape shape, ShapeReader reader, ShapeWriter writer) throws IOException, ParseException {
        Assert.assertNotNull((Object)shape);
        StringWriter str = new StringWriter();
        writer.write((Writer)str, shape);
        Shape out = reader.read((Reader)new StringReader(str.toString()));
        StringWriter copy = new StringWriter();
        writer.write((Writer)copy, out);
        Assert.assertEquals((Object)str.toString(), (Object)copy.toString());
        return out;
    }

    public void testCommon(SpatialContext ctx, String name) throws Exception {
        ShapeReader reader = ctx.getFormats().getReader(name);
        ShapeWriter writer = ctx.getFormats().getWriter(name);
        Assert.assertNotNull((Object)reader);
        Assert.assertNotNull((Object)writer);
        this.testReadAndWriteTheSame((Shape)ctx.makePoint(10.0, 20.0), reader, writer);
        this.testReadAndWriteTheSame(ctx.makeLineString(Arrays.asList(ctx.makePoint(1.0, 2.0), ctx.makePoint(3.0, 4.0), ctx.makePoint(5.0, 6.0))), reader, writer);
    }

    public void testJTS(JtsSpatialContext ctx, String name) throws Exception {
        ShapeReader reader = ctx.getFormats().getReader(name);
        ShapeWriter writer = ctx.getFormats().getWriter(name);
        Shape shape = this.wkt((SpatialContext)ctx, "LINESTRING (30 10, 10 30, 40 40)");
        shape = this.wkt((SpatialContext)ctx, "POLYGON ((35 10, 45 45, 15 40, 10 20, 35 10))");
        this.testReadAndWriteTheSame(shape, reader, writer);
        shape = this.wkt((SpatialContext)ctx, "POLYGON ((35 10, 45 45, 15 40, 10 20, 35 10),(20 30, 35 35, 30 20, 20 30))");
        this.testReadAndWriteTheSame(shape, reader, writer);
        shape = this.wkt((SpatialContext)ctx, "MULTIPOINT ((10 40), (40 30), (20 20), (30 10))");
        this.testReadAndWriteTheSame(shape, reader, writer);
        shape = this.wkt((SpatialContext)ctx, "MULTIPOINT (10 40, 40 30, 20 20, 30 10)");
        this.testReadAndWriteTheSame(shape, reader, writer);
        shape = this.wkt((SpatialContext)ctx, "MULTILINESTRING ((10 10, 20 20, 10 40),(40 40, 30 30, 40 20, 30 10))");
        this.testReadAndWriteTheSame(shape, reader, writer);
        shape = this.wkt((SpatialContext)ctx, "MULTIPOLYGON (((30 20, 45 40, 10 40, 30 20)),((15 5, 40 10, 10 20, 5 10, 15 5)))");
        this.testReadAndWriteTheSame(shape, reader, writer);
    }

    @Test
    public void testReadAndWriteTheSame() throws Exception {
        String format = "GeoJSON";
        this.testCommon(SpatialContext.GEO, format);
        this.testCommon((SpatialContext)JtsSpatialContext.GEO, format);
        this.testJTS(JtsSpatialContext.GEO, format);
        format = "WKT";
        this.testCommon(SpatialContext.GEO, format);
        this.testCommon((SpatialContext)JtsSpatialContext.GEO, format);
        this.testJTS(JtsSpatialContext.GEO, format);
    }

    public void testParseVsInvalidExceptions(ShapeReader reader, boolean supportsPolygon) throws Exception {
        String txt = null;
        try {
            txt = "garbage";
            reader.read((Object)txt);
            Assert.fail((String)"should throw invalid exception");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        try {
            txt = "POINT(-1000 1000)";
            reader.read((Object)txt);
            Assert.fail((String)"should throw invalid shape");
        }
        catch (InvalidShapeException invalidShapeException) {
            // empty catch block
        }
        if (supportsPolygon) {
            try {
                txt = this.readFirstLineFromRsrc("/fiji.wkt.txt");
                reader.read((Object)txt);
                Assert.fail((String)"should throw invalid exception");
            }
            catch (InvalidShapeException invalidShapeException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testParseVsInvalidExceptions() throws Exception {
        this.testParseVsInvalidExceptions(SpatialContext.GEO.getFormats().getWktReader(), false);
        this.testParseVsInvalidExceptions(JtsSpatialContext.GEO.getFormats().getWktReader(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFirstLineFromRsrc(String wktRsrcPath) throws IOException {
        Assert.assertNotNull((Object)is);
        try (InputStream is = this.getClass().getResourceAsStream(wktRsrcPath);){
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String string = br.readLine();
            return string;
        }
    }

    protected Shape wkt(SpatialContext ctx, String wkt) throws IOException, ParseException {
        return ctx.getFormats().getWktReader().read((Object)wkt);
    }
}

