/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import com.carrotsearch.hppc.LongIntScatterMap;
import com.carrotsearch.hppc.cursors.LongIntCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConjunctionDISI;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.PriorityQueue;

public class LongValueFacetCounts
extends Facets {
    private final int[] counts = new int[1024];
    private final LongIntScatterMap hashCounts = new LongIntScatterMap();
    private final String field;
    private int totCount;

    public LongValueFacetCounts(String field, FacetsCollector hits, boolean multiValued) throws IOException {
        this(field, null, hits, multiValued);
    }

    public LongValueFacetCounts(String field, LongValuesSource valueSource, FacetsCollector hits) throws IOException {
        this(field, valueSource, hits, false);
    }

    public LongValueFacetCounts(String field, LongValuesSource valueSource, FacetsCollector hits, boolean multiValued) throws IOException {
        this.field = field;
        if (valueSource == null) {
            if (multiValued) {
                this.countMultiValued(field, hits.getMatchingDocs());
            } else {
                this.count(field, hits.getMatchingDocs());
            }
        } else {
            if (multiValued) {
                throw new IllegalArgumentException("can only compute multi-valued facets directly from doc values (when valueSource is null)");
            }
            this.count(valueSource, hits.getMatchingDocs());
        }
    }

    public LongValueFacetCounts(String field, IndexReader reader, boolean multiValued) throws IOException {
        this.field = field;
        if (multiValued) {
            this.countAllMultiValued(reader, field);
        } else {
            this.countAll(reader, field);
        }
    }

    public LongValueFacetCounts(String field, LongValuesSource valueSource, IndexReader reader) throws IOException {
        this.field = field;
        this.countAll(valueSource, field, reader);
    }

    private void count(LongValuesSource valueSource, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            LongValues fv = valueSource.getValues(hits.context, null);
            DocIdSetIterator docs = hits.bits.iterator();
            int doc = docs.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (fv.advanceExact(doc)) {
                    this.increment(fv.longValue());
                    ++this.totCount;
                }
                doc = docs.nextDoc();
            }
        }
    }

    private void count(String field, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            NumericDocValues fv = hits.context.reader().getNumericDocValues(field);
            if (fv == null) continue;
            this.countOneSegment(fv, hits);
        }
    }

    private void countOneSegment(NumericDocValues values, FacetsCollector.MatchingDocs hits) throws IOException {
        DocIdSetIterator it = ConjunctionDISI.intersectIterators(Arrays.asList(hits.bits.iterator(), values));
        int doc = it.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            this.increment(values.longValue());
            ++this.totCount;
            doc = it.nextDoc();
        }
    }

    private void countMultiValued(String field, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            SortedNumericDocValues values = hits.context.reader().getSortedNumericDocValues(field);
            if (values == null) continue;
            NumericDocValues singleValues = DocValues.unwrapSingleton((SortedNumericDocValues)values);
            if (singleValues != null) {
                this.countOneSegment(singleValues, hits);
                continue;
            }
            DocIdSetIterator it = ConjunctionDISI.intersectIterators(Arrays.asList(hits.bits.iterator(), values));
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                int limit = values.docValueCount();
                if (limit > 0) {
                    ++this.totCount;
                }
                for (int i = 0; i < limit; ++i) {
                    this.increment(values.nextValue());
                }
                doc = it.nextDoc();
            }
        }
    }

    private void countAll(IndexReader reader, String field) throws IOException {
        for (LeafReaderContext context : reader.leaves()) {
            NumericDocValues values = context.reader().getNumericDocValues(field);
            if (values == null) continue;
            this.countAllOneSegment(values);
        }
    }

    private void countAllOneSegment(NumericDocValues values) throws IOException {
        int doc;
        while ((doc = values.nextDoc()) != Integer.MAX_VALUE) {
            ++this.totCount;
            this.increment(values.longValue());
        }
    }

    private void countAll(LongValuesSource valueSource, String field, IndexReader reader) throws IOException {
        for (LeafReaderContext context : reader.leaves()) {
            LongValues fv = valueSource.getValues(context, null);
            int maxDoc = context.reader().maxDoc();
            for (int doc = 0; doc < maxDoc; ++doc) {
                if (!fv.advanceExact(doc)) continue;
                this.increment(fv.longValue());
                ++this.totCount;
            }
        }
    }

    private void countAllMultiValued(IndexReader reader, String field) throws IOException {
        for (LeafReaderContext context : reader.leaves()) {
            int doc;
            SortedNumericDocValues values = context.reader().getSortedNumericDocValues(field);
            if (values == null) continue;
            NumericDocValues singleValues = DocValues.unwrapSingleton((SortedNumericDocValues)values);
            if (singleValues != null) {
                this.countAllOneSegment(singleValues);
                continue;
            }
            while ((doc = values.nextDoc()) != Integer.MAX_VALUE) {
                int limit = values.docValueCount();
                if (limit > 0) {
                    ++this.totCount;
                }
                for (int i = 0; i < limit; ++i) {
                    this.increment(values.nextValue());
                }
            }
        }
    }

    private void increment(long value) {
        if (value >= 0L && value < (long)this.counts.length) {
            int n = (int)value;
            this.counts[n] = this.counts[n] + 1;
        } else {
            this.hashCounts.addTo(value, 1);
        }
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) {
        if (!dim.equals(this.field)) {
            throw new IllegalArgumentException("invalid dim \"" + dim + "\"; should be \"" + this.field + "\"");
        }
        if (path.length != 0) {
            throw new IllegalArgumentException("path.length should be 0");
        }
        return this.getTopChildrenSortByCount(topN);
    }

    public FacetResult getTopChildrenSortByCount(int topN) {
        PriorityQueue<Entry> pq = new PriorityQueue<Entry>(Math.min(topN, this.counts.length + this.hashCounts.size())){

            protected boolean lessThan(Entry a, Entry b) {
                return a.count < b.count || a.count == b.count && a.value > b.value;
            }
        };
        int childCount = 0;
        Entry e = null;
        for (int i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] == 0) continue;
            ++childCount;
            if (e == null) {
                e = new Entry();
            }
            e.value = i;
            e.count = this.counts[i];
            e = (Entry)pq.insertWithOverflow((Object)e);
        }
        if (this.hashCounts.size() != 0) {
            childCount += this.hashCounts.size();
            for (LongIntCursor c : this.hashCounts) {
                int count = c.value;
                if (count == 0) continue;
                if (e == null) {
                    e = new Entry();
                }
                e.value = c.key;
                e.count = count;
                e = (Entry)pq.insertWithOverflow((Object)e);
            }
        }
        LabelAndValue[] results = new LabelAndValue[pq.size()];
        while (pq.size() != 0) {
            Entry entry = (Entry)pq.pop();
            results[pq.size()] = new LabelAndValue(Long.toString(entry.value), entry.count);
        }
        return new FacetResult(this.field, new String[0], this.totCount, results, childCount);
    }

    public FacetResult getAllChildrenSortByValue() {
        ArrayList<LabelAndValue> labelValues = new ArrayList<LabelAndValue>();
        final int[] hashCounts = new int[this.hashCounts.size()];
        final long[] hashValues = new long[this.hashCounts.size()];
        int upto = 0;
        for (LongIntCursor c : this.hashCounts) {
            if (c.value == 0) continue;
            hashCounts[upto] = c.value;
            hashValues[upto] = c.key;
            ++upto;
        }
        assert (upto == this.hashCounts.size()) : "upto=" + upto + " hashCounts.size=" + this.hashCounts.size();
        new InPlaceMergeSorter(){

            public int compare(int i, int j) {
                return Long.compare(hashValues[i], hashValues[j]);
            }

            public void swap(int i, int j) {
                int x = hashCounts[i];
                hashCounts[i] = hashCounts[j];
                hashCounts[j] = x;
                long y = hashValues[j];
                hashValues[j] = hashValues[i];
                hashValues[i] = y;
            }
        }.sort(0, upto);
        boolean countsAdded = false;
        for (int i = 0; i < upto; ++i) {
            if (!countsAdded && hashValues[i] >= (long)this.counts.length) {
                countsAdded = true;
                this.appendCounts(labelValues);
            }
            labelValues.add(new LabelAndValue(Long.toString(hashValues[i]), hashCounts[i]));
        }
        if (!countsAdded) {
            this.appendCounts(labelValues);
        }
        return new FacetResult(this.field, new String[0], this.totCount, labelValues.toArray(new LabelAndValue[0]), labelValues.size());
    }

    private void appendCounts(List<LabelAndValue> labelValues) {
        for (int i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] == 0) continue;
            labelValues.add(new LabelAndValue(Long.toString(i), this.counts[i]));
        }
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<FacetResult> getAllDims(int topN) throws IOException {
        return Collections.singletonList(this.getTopChildren(topN, this.field, new String[0]));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LongValueFacetCounts totCount=");
        b.append(this.totCount);
        b.append(":\n");
        for (int i = 0; i < this.counts.length; ++i) {
            if (this.counts[i] == 0) continue;
            b.append("  ");
            b.append(i);
            b.append(" -> count=");
            b.append(this.counts[i]);
            b.append('\n');
        }
        if (this.hashCounts.size() != 0) {
            for (LongIntCursor c : this.hashCounts) {
                if (c.value == 0) continue;
                b.append("  ");
                b.append(c.key);
                b.append(" -> count=");
                b.append(c.value);
                b.append('\n');
            }
        }
        return b.toString();
    }

    private static class Entry {
        int count;
        long value;

        private Entry() {
        }
    }
}

