/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.fragments.search;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.custom.CustomAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.luke.app.desktop.components.ComponentOperatorRegistry;
import org.apache.lucene.luke.app.desktop.components.TabSwitcherProxy;
import org.apache.lucene.luke.app.desktop.components.TabbedPaneProvider;
import org.apache.lucene.luke.app.desktop.components.fragments.search.AnalyzerTabOperator;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;

public final class AnalyzerPaneProvider
implements AnalyzerTabOperator {
    private final TabSwitcherProxy tabSwitcher;
    private final JLabel analyzerNameLbl = new JLabel(StandardAnalyzer.class.getName());
    private final JList<String> charFilterList = new JList();
    private final JTextField tokenizerTF = new JTextField();
    private final JList<String> tokenFilterList = new JList();

    public AnalyzerPaneProvider() {
        this.tabSwitcher = TabSwitcherProxy.getInstance();
        ComponentOperatorRegistry.getInstance().register(AnalyzerTabOperator.class, this);
    }

    public JScrollPane get() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        panel.add(this.initAnalyzerNamePanel());
        panel.add(new JSeparator(0));
        panel.add(this.initAnalysisChainPanel());
        this.tokenizerTF.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(panel);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        return scrollPane;
    }

    private JPanel initAnalyzerNamePanel() {
        JPanel panel = new JPanel(new FlowLayout(3));
        panel.setOpaque(false);
        panel.add(new JLabel(MessageUtils.getLocalizedMessage("search_analyzer.label.name")));
        panel.add(this.analyzerNameLbl);
        JLabel changeLbl = new JLabel(MessageUtils.getLocalizedMessage("search_analyzer.hyperlink.change"));
        changeLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AnalyzerPaneProvider.this.tabSwitcher.switchTab(TabbedPaneProvider.Tab.ANALYZER);
            }
        });
        panel.add(FontUtils.toLinkText(changeLbl));
        return panel;
    }

    private JPanel initAnalysisChainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        JPanel top = new JPanel(new FlowLayout(3));
        top.setOpaque(false);
        top.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        top.add(new JLabel(MessageUtils.getLocalizedMessage("search_analyzer.label.chain")));
        panel.add((Component)top, "First");
        JPanel center = new JPanel(new GridBagLayout());
        center.setOpaque(false);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.1;
        center.add((Component)new JLabel(MessageUtils.getLocalizedMessage("search_analyzer.label.charfilters")), c);
        this.charFilterList.setVisibleRowCount(3);
        JScrollPane charFilterSP = new JScrollPane(this.charFilterList);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.5;
        center.add((Component)charFilterSP, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.1;
        center.add((Component)new JLabel(MessageUtils.getLocalizedMessage("search_analyzer.label.tokenizer")), c);
        this.tokenizerTF.setColumns(30);
        this.tokenizerTF.setPreferredSize(new Dimension(400, 25));
        this.tokenizerTF.setBorder(BorderFactory.createLineBorder(Color.gray));
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 0.5;
        center.add((Component)this.tokenizerTF, c);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.1;
        center.add((Component)new JLabel(MessageUtils.getLocalizedMessage("search_analyzer.label.tokenfilters")), c);
        this.tokenFilterList.setVisibleRowCount(3);
        JScrollPane tokenFilterSP = new JScrollPane(this.tokenFilterList);
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 0.5;
        center.add((Component)tokenFilterSP, c);
        panel.add((Component)center, "Center");
        return panel;
    }

    @Override
    public void setAnalyzer(Analyzer analyzer) {
        this.analyzerNameLbl.setText(analyzer.getClass().getName());
        if (analyzer instanceof CustomAnalyzer) {
            CustomAnalyzer customAnalyzer = (CustomAnalyzer)analyzer;
            DefaultListModel charFilterListModel = new DefaultListModel();
            customAnalyzer.getCharFilterFactories().stream().map(f -> f.getClass().getSimpleName()).forEach(charFilterListModel::addElement);
            this.charFilterList.setModel(charFilterListModel);
            this.tokenizerTF.setText(customAnalyzer.getTokenizerFactory().getClass().getSimpleName());
            DefaultListModel tokenFilterListModel = new DefaultListModel();
            customAnalyzer.getTokenFilterFactories().stream().map(f -> f.getClass().getSimpleName()).forEach(tokenFilterListModel::addElement);
            this.tokenFilterList.setModel(tokenFilterListModel);
            this.charFilterList.setBackground(Color.white);
            this.tokenizerTF.setBackground(Color.white);
            this.tokenFilterList.setBackground(Color.white);
        } else {
            this.charFilterList.setModel(new DefaultListModel());
            this.tokenizerTF.setText("");
            this.tokenFilterList.setModel(new DefaultListModel());
            this.charFilterList.setBackground(Color.lightGray);
            this.tokenizerTF.setBackground(Color.lightGray);
            this.tokenFilterList.setBackground(Color.lightGray);
        }
    }
}

