/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.PreferencesFactory;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.lang.Callable;

public final class ConfirmDialogFactory
implements DialogOpener.DialogFactory {
    private static ConfirmDialogFactory instance;
    private final Preferences prefs = PreferencesFactory.getInstance();
    private JDialog dialog;
    private String message;
    private Callable callback;

    public static synchronized ConfirmDialogFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new ConfirmDialogFactory();
        }
        return instance;
    }

    private ConfirmDialogFactory() throws IOException {
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCallback(Callable callback) {
        this.callback = callback;
    }

    @Override
    public JDialog create(Window owner, String title, int width, int height) {
        this.dialog = new JDialog(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.add(this.content());
        this.dialog.setSize(new Dimension(width, height));
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.getContentPane().setBackground(this.prefs.getColorTheme().getBackgroundColor());
        return this.dialog;
    }

    private JPanel content() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JPanel header = new JPanel(new FlowLayout(3));
        header.setOpaque(false);
        JLabel alertIconLbl = new JLabel(FontUtils.elegantIconHtml("&#x71;"));
        alertIconLbl.setHorizontalAlignment(0);
        alertIconLbl.setFont(new Font(alertIconLbl.getFont().getFontName(), 0, 25));
        header.add(alertIconLbl);
        panel.add((Component)header, "First");
        JPanel center = new JPanel(new GridLayout(1, 1));
        center.setOpaque(false);
        center.setBorder(BorderFactory.createLineBorder(Color.gray, 3));
        center.add(new JLabel(this.message, 0));
        panel.add((Component)center, "Center");
        JPanel footer = new JPanel(new FlowLayout(4));
        footer.setOpaque(false);
        JButton okBtn = new JButton(MessageUtils.getLocalizedMessage("button.ok"));
        okBtn.addActionListener(e -> {
            this.callback.call();
            this.dialog.dispose();
        });
        footer.add(okBtn);
        JButton closeBtn = new JButton(MessageUtils.getLocalizedMessage("button.close"));
        closeBtn.addActionListener(e -> this.dialog.dispose());
        footer.add(closeBtn);
        panel.add((Component)footer, "Last");
        return panel;
    }
}

