/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io.jackson;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.io.GeneralGeoJSONTest;
import org.locationtech.spatial4j.io.jackson.JacksonShapeWriter;
import org.locationtech.spatial4j.io.jackson.ShapesAsGeoJSONModule;
import org.locationtech.spatial4j.shape.Shape;
import org.mockito.Mockito;

public class JacksonGeoJSONWriterTest
extends GeneralGeoJSONTest {
    @Override
    @Before
    public void setUp() {
        super.setUp();
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new ShapesAsGeoJSONModule());
        JacksonShapeWriter w = new JacksonShapeWriter(mapper);
        this.reader = ((JtsSpatialContext)this.ctx).getFormats().getReader("GeoJSON");
        this.writerForTests = this.writer = w;
        Assert.assertNotNull((Object)this.reader);
        Assert.assertNotNull((Object)this.writer);
        Assert.assertNotNull((Object)this.writerForTests);
    }

    @Test
    public void testWriteUnknownAsWKT() throws Exception {
        Shape shape = (Shape)Mockito.mock(Shape.class);
        Mockito.when((Object)shape.getContext()).thenReturn((Object)SpatialContext.GEO);
        String str = this.writer.toString(shape);
        Assert.assertTrue((str.indexOf("wkt") > 0 ? 1 : 0) != 0);
    }
}

