/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.annotations.ParametersFactory;
import java.io.IOException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.io.LegacyShapeReader;
import org.locationtech.spatial4j.io.LegacyShapeWriter;
import org.locationtech.spatial4j.shape.Shape;

public class LegacyShapeReadWriterTest
extends RandomizedTest {
    private final LegacyShapeReader reader;
    private final LegacyShapeWriter writer;
    private final SpatialContext ctx;

    @ParametersFactory
    public static Iterable<Object[]> parameters() {
        return Arrays.asList(LegacyShapeReadWriterTest.$$((Object[][])new Object[][]{LegacyShapeReadWriterTest.$((Object[])new Object[]{SpatialContext.GEO}), LegacyShapeReadWriterTest.$((Object[])new Object[]{JtsSpatialContext.GEO})}));
    }

    public LegacyShapeReadWriterTest(SpatialContext ctx) {
        this.ctx = ctx;
        this.reader = new LegacyShapeReader(ctx, null);
        this.writer = new LegacyShapeWriter(ctx, null);
    }

    private <T extends Shape> T writeThenRead(T s) throws IOException {
        String buff = this.writer.toString(s);
        return (T)this.read(buff);
    }

    private Shape read(String value) {
        return this.reader.readIfSupported((Object)value);
    }

    @Test
    public void testPoint() throws IOException {
        Shape s = this.read("10 20");
        Assert.assertEquals((Object)this.ctx.makePoint(10.0, 20.0), (Object)s);
        Assert.assertEquals((Object)s, (Object)this.writeThenRead(s));
        Assert.assertEquals((Object)s, (Object)this.read("20,10"));
        Assert.assertEquals((Object)s, (Object)this.read("20, 10"));
        Assert.assertFalse((boolean)s.hasArea());
    }

    @Test
    public void testRectangle() throws IOException {
        Shape s = this.read("-10 -20 10 20");
        Assert.assertEquals((Object)this.ctx.makeRectangle(-10.0, 10.0, -20.0, 20.0), (Object)s);
        Assert.assertEquals((Object)s, (Object)this.writeThenRead(s));
        Assert.assertTrue((boolean)s.hasArea());
    }

    @Test
    public void testCircle() throws IOException {
        Shape s = this.read("Circle(1.23 4.56 distance=7.89)");
        Assert.assertEquals((Object)this.ctx.makeCircle(1.23, 4.56, 7.89), (Object)s);
        Assert.assertEquals((Object)s, (Object)this.writeThenRead(s));
        Assert.assertEquals((Object)s, (Object)this.read("CIRCLE( 4.56,1.23 d=7.89 )"));
        Assert.assertTrue((boolean)s.hasArea());
    }
}

