/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io;

import java.io.IOException;
import java.text.ParseException;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;
import org.locationtech.spatial4j.util.Geom;

public class JtsPolyshapeParserTest {
    @Test
    public void testUseMulti() throws IOException, ParseException {
        String ps = this.write((Geometry)Geom.build().point(0.0, 0.0).point(0.0, 0.0).toMultiPoint());
        Shape shape = this.newContext(false).getFormats().getReader("POLY").read((Object)ps);
        Assert.assertTrue((boolean)(shape instanceof ShapeCollection));
        shape = this.newContext(true).getFormats().getReader("POLY").read((Object)ps);
        Assert.assertTrue((boolean)(shape instanceof JtsGeometry));
        Assert.assertTrue((boolean)(((JtsGeometry)shape).getGeom() instanceof MultiPoint));
    }

    JtsSpatialContext newContext(boolean useMulti) {
        JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
        factory.useJtsMulti = useMulti;
        return factory.newSpatialContext();
    }

    String write(Geometry g) {
        JtsGeometry shp = JtsSpatialContext.GEO.getShapeFactory().makeShape(g);
        return JtsSpatialContext.GEO.getFormats().getWriter("POLY").toString((Shape)shp);
    }
}

