/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.dialog.menubar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.luke.app.DirectoryHandler;
import org.apache.lucene.luke.app.DirectoryObserver;
import org.apache.lucene.luke.app.IndexHandler;
import org.apache.lucene.luke.app.IndexObserver;
import org.apache.lucene.luke.app.LukeState;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.PreferencesFactory;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.ImageUtils;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.StyleConstants;
import org.apache.lucene.luke.app.desktop.util.TextAreaPrintStream;
import org.apache.lucene.luke.models.tools.IndexTools;
import org.apache.lucene.luke.models.tools.IndexToolsFactory;
import org.apache.lucene.luke.util.LoggerFactory;
import org.apache.lucene.util.NamedThreadFactory;

public final class CheckIndexDialogFactory
implements DialogOpener.DialogFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static CheckIndexDialogFactory instance;
    private final Preferences prefs;
    private final IndexToolsFactory indexToolsFactory;
    private final DirectoryHandler directoryHandler;
    private final IndexHandler indexHandler;
    private final JLabel resultLbl = new JLabel();
    private final JLabel statusLbl = new JLabel();
    private final JLabel indicatorLbl = new JLabel();
    private final JButton repairBtn = new JButton();
    private final JTextArea logArea = new JTextArea();
    private JDialog dialog;
    private LukeState lukeState;
    private CheckIndex.Status status;
    private IndexTools toolsModel;
    private final ListenerFunctions listeners = new ListenerFunctions();

    public static synchronized CheckIndexDialogFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new CheckIndexDialogFactory();
        }
        return instance;
    }

    private CheckIndexDialogFactory() throws IOException {
        this.prefs = PreferencesFactory.getInstance();
        this.indexToolsFactory = new IndexToolsFactory();
        this.indexHandler = IndexHandler.getInstance();
        this.directoryHandler = DirectoryHandler.getInstance();
        this.indexHandler.addObserver(new Observer());
        this.directoryHandler.addObserver(new Observer());
        this.initialize();
    }

    private void initialize() {
        this.repairBtn.setText(FontUtils.elegantIconHtml("&#xe036;", MessageUtils.getLocalizedMessage("checkidx.button.fix")));
        this.repairBtn.setFont(StyleConstants.FONT_BUTTON_LARGE);
        this.repairBtn.setMargin(new Insets(3, 3, 3, 3));
        this.repairBtn.setEnabled(false);
        this.repairBtn.addActionListener(this.listeners::repairIndex);
        this.indicatorLbl.setIcon(ImageUtils.createImageIcon("indicator.gif", 20, 20));
        this.logArea.setEditable(false);
    }

    @Override
    public JDialog create(Window owner, String title, int width, int height) {
        this.dialog = new JDialog(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.add(this.content());
        this.dialog.setSize(new Dimension(width, height));
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.getContentPane().setBackground(this.prefs.getColorTheme().getBackgroundColor());
        return this.dialog;
    }

    private JPanel content() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        panel.add(this.controller());
        panel.add(new JSeparator(0));
        panel.add(this.logs());
        return panel;
    }

    private JPanel controller() {
        JPanel panel = new JPanel(new GridLayout(3, 1));
        panel.setOpaque(false);
        JPanel idxPath = new JPanel(new FlowLayout(3));
        idxPath.setOpaque(false);
        idxPath.add(new JLabel(MessageUtils.getLocalizedMessage("checkidx.label.index_path")));
        JLabel idxPathLbl = new JLabel(this.lukeState.getIndexPath());
        idxPathLbl.setToolTipText(this.lukeState.getIndexPath());
        idxPath.add(idxPathLbl);
        panel.add(idxPath);
        JPanel results = new JPanel(new GridLayout(2, 1));
        results.setOpaque(false);
        results.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        results.add(new JLabel(MessageUtils.getLocalizedMessage("checkidx.label.results")));
        results.add(this.resultLbl);
        panel.add(results);
        JPanel execButtons = new JPanel(new FlowLayout(4));
        execButtons.setOpaque(false);
        JButton checkBtn = new JButton(FontUtils.elegantIconHtml("&#xe0f7;", MessageUtils.getLocalizedMessage("checkidx.button.check")));
        checkBtn.setFont(StyleConstants.FONT_BUTTON_LARGE);
        checkBtn.setMargin(new Insets(3, 0, 3, 0));
        checkBtn.addActionListener(this.listeners::checkIndex);
        execButtons.add(checkBtn);
        JButton closeBtn = new JButton(MessageUtils.getLocalizedMessage("button.close"));
        closeBtn.setFont(StyleConstants.FONT_BUTTON_LARGE);
        closeBtn.setMargin(new Insets(3, 0, 3, 0));
        closeBtn.addActionListener(e -> this.dialog.dispose());
        execButtons.add(closeBtn);
        panel.add(execButtons);
        return panel;
    }

    private JPanel logs() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        JPanel header = new JPanel();
        header.setOpaque(false);
        header.setLayout(new BoxLayout(header, 3));
        JPanel repair = new JPanel(new FlowLayout(3));
        repair.setOpaque(false);
        repair.add(this.repairBtn);
        JTextArea warnArea = new JTextArea(MessageUtils.getLocalizedMessage("checkidx.label.warn"), 3, 30);
        warnArea.setLineWrap(true);
        warnArea.setEditable(false);
        warnArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        repair.add(warnArea);
        header.add(repair);
        JPanel note = new JPanel(new FlowLayout(3));
        note.setOpaque(false);
        note.add(new JLabel(MessageUtils.getLocalizedMessage("checkidx.label.note")));
        header.add(note);
        JPanel status = new JPanel(new FlowLayout(3));
        status.setOpaque(false);
        status.add(new JLabel(MessageUtils.getLocalizedMessage("label.status")));
        this.statusLbl.setText("Idle");
        status.add(this.statusLbl);
        this.indicatorLbl.setVisible(false);
        status.add(this.indicatorLbl);
        header.add(status);
        panel.add((Component)header, "First");
        this.logArea.setText("");
        panel.add((Component)new JScrollPane(this.logArea), "Center");
        return panel;
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void checkIndex(ActionEvent e) {
            ExecutorService executor = Executors.newFixedThreadPool(1, (ThreadFactory)new NamedThreadFactory("check-index-dialog-check"));
            SwingWorker<CheckIndex.Status, Void> task = new SwingWorker<CheckIndex.Status, Void>(){

                @Override
                protected CheckIndex.Status doInBackground() {
                    this.setProgress(0);
                    CheckIndexDialogFactory.this.statusLbl.setText("Running...");
                    CheckIndexDialogFactory.this.indicatorLbl.setVisible(true);
                    try {
                        TextAreaPrintStream ps = new TextAreaPrintStream(CheckIndexDialogFactory.this.logArea);
                        CheckIndex.Status status = CheckIndexDialogFactory.this.toolsModel.checkIndex(ps);
                        ps.flush();
                        CheckIndex.Status status2 = status;
                        return status2;
                    }
                    catch (UnsupportedEncodingException status) {
                    }
                    catch (Exception e) {
                        CheckIndexDialogFactory.this.statusLbl.setText(MessageUtils.getLocalizedMessage("message.error.unknown"));
                        throw e;
                    }
                    finally {
                        this.setProgress(100);
                    }
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        CheckIndex.Status st = (CheckIndex.Status)this.get();
                        CheckIndexDialogFactory.this.resultLbl.setText(ListenerFunctions.this.createResultsMessage(st));
                        CheckIndexDialogFactory.this.indicatorLbl.setVisible(false);
                        CheckIndexDialogFactory.this.statusLbl.setText("Done");
                        if (!st.clean) {
                            CheckIndexDialogFactory.this.repairBtn.setEnabled(true);
                        }
                        CheckIndexDialogFactory.this.status = st;
                    }
                    catch (Exception e) {
                        log.error("Error checking index", (Throwable)e);
                        CheckIndexDialogFactory.this.statusLbl.setText(MessageUtils.getLocalizedMessage("message.error.unknown"));
                    }
                }
            };
            executor.submit(task);
            executor.shutdown();
        }

        private String createResultsMessage(CheckIndex.Status status) {
            String msg;
            if (status == null) {
                msg = "?";
            } else if (status.clean) {
                msg = "OK";
            } else if (status.toolOutOfDate) {
                msg = "ERROR: Can't check - tool out-of-date";
            } else {
                StringBuilder sb = new StringBuilder("BAD:");
                if (status.missingSegments) {
                    sb.append(" Missing segments.");
                }
                if (status.numBadSegments > 0) {
                    sb.append(" numBadSegments=");
                    sb.append(status.numBadSegments);
                }
                if (status.totLoseDocCount > 0) {
                    sb.append(" totLoseDocCount=");
                    sb.append(status.totLoseDocCount);
                }
                msg = sb.toString();
            }
            return msg;
        }

        void repairIndex(ActionEvent e) {
            if (CheckIndexDialogFactory.this.status == null) {
                return;
            }
            ExecutorService executor = Executors.newFixedThreadPool(1, (ThreadFactory)new NamedThreadFactory("check-index-dialog-repair"));
            SwingWorker<CheckIndex.Status, Void> task = new SwingWorker<CheckIndex.Status, Void>(){

                @Override
                protected CheckIndex.Status doInBackground() {
                    this.setProgress(0);
                    CheckIndexDialogFactory.this.statusLbl.setText("Running...");
                    CheckIndexDialogFactory.this.indicatorLbl.setVisible(true);
                    CheckIndexDialogFactory.this.logArea.setText("");
                    try {
                        TextAreaPrintStream ps = new TextAreaPrintStream(CheckIndexDialogFactory.this.logArea);
                        CheckIndexDialogFactory.this.toolsModel.repairIndex(CheckIndexDialogFactory.this.status, ps);
                        CheckIndexDialogFactory.this.statusLbl.setText("Done");
                        ps.flush();
                        CheckIndex.Status status = CheckIndexDialogFactory.this.status;
                        return status;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                    }
                    catch (Exception e) {
                        CheckIndexDialogFactory.this.statusLbl.setText(MessageUtils.getLocalizedMessage("message.error.unknown"));
                        throw e;
                    }
                    finally {
                        this.setProgress(100);
                    }
                    return null;
                }

                @Override
                protected void done() {
                    CheckIndexDialogFactory.this.indexHandler.open(CheckIndexDialogFactory.this.lukeState.getIndexPath(), CheckIndexDialogFactory.this.lukeState.getDirImpl());
                    CheckIndexDialogFactory.this.logArea.append("Repairing index done.");
                    CheckIndexDialogFactory.this.resultLbl.setText("");
                    CheckIndexDialogFactory.this.indicatorLbl.setVisible(false);
                    CheckIndexDialogFactory.this.repairBtn.setEnabled(false);
                }
            };
            executor.submit(task);
            executor.shutdown();
        }
    }

    private class Observer
    implements IndexObserver,
    DirectoryObserver {
        private Observer() {
        }

        @Override
        public void openIndex(LukeState state) {
            CheckIndexDialogFactory.this.lukeState = state;
            CheckIndexDialogFactory.this.toolsModel = CheckIndexDialogFactory.this.indexToolsFactory.newInstance(state.getIndexReader(), state.useCompound(), state.keepAllCommits());
        }

        @Override
        public void closeIndex() {
            this.close();
        }

        @Override
        public void openDirectory(LukeState state) {
            CheckIndexDialogFactory.this.lukeState = state;
            CheckIndexDialogFactory.this.toolsModel = CheckIndexDialogFactory.this.indexToolsFactory.newInstance(state.getDirectory());
        }

        @Override
        public void closeDirectory() {
            this.close();
        }

        private void close() {
            CheckIndexDialogFactory.this.toolsModel = null;
        }
    }
}

