/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.context.jts;

import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.spatial4j.context.jts.DatelineRule;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;
import org.locationtech.spatial4j.shape.jts.JtsShapeFactory;
import org.locationtech.spatial4j.util.Geom;

public class JtsSpatialContextTest {
    @Test
    public void testDatelineRule() {
        Polygon polygon = Geom.build().points(-179.0, -90.0, 179.0, -90.0, 179.0, 90.0, -179.0, 90.0).toPolygon();
        JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
        factory.datelineRule = DatelineRule.width180;
        JtsSpatialContext ctx = factory.newSpatialContext();
        Polygon polygonCloned = polygon.copy();
        JtsGeometry shp = ctx.makeShape((Geometry)polygonCloned);
        Assert.assertEquals((String)"shouldn't be modified after calling makeShape", (Object)polygon, (Object)polygonCloned);
        Assert.assertTrue((boolean)(shp.getGeom() instanceof GeometryCollection));
        factory.datelineRule = DatelineRule.none;
        ctx = factory.newSpatialContext();
        shp = ctx.makeShape((Geometry)polygon);
        Assert.assertTrue((boolean)(shp.getGeom() instanceof Polygon));
    }

    @Test
    public void testDatelineRuleWithMultiPolygon() {
        JtsSpatialContext ctx = new JtsSpatialContextFactory().newSpatialContext();
        JtsShapeFactory shapeFactory = ctx.getShapeFactory();
        GeometryFactory geomFactory = shapeFactory.getGeometryFactory();
        Polygon poly1Geom = Geom.build().points(-179.0, -90.0, 179.0, -90.0, 179.0, 90.0, -179.0, 90.0).toPolygon();
        Polygon poly2Geom = Geom.build().points(0.0, 0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0).toPolygon();
        GeometryCollection geomColl = geomFactory.createGeometryCollection(new Geometry[]{poly1Geom, poly2Geom});
        JtsGeometry jtsGeometry = shapeFactory.makeShape((Geometry)geomColl);
        Assert.assertEquals((Object)"MULTIPOLYGON (((-180 -90, -180 90, -179 90, -179 -90, -180 -90)), ((179 90, 180 90, 180 -90, 179 -90, 179 90)), ((0 0, 1 1, 1 0, 0 0)))", (Object)jtsGeometry.toString());
    }
}

