/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.dialog.menubar;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.luke.app.IndexHandler;
import org.apache.lucene.luke.app.IndexObserver;
import org.apache.lucene.luke.app.LukeState;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.PreferencesFactory;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.ImageUtils;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.StyleConstants;
import org.apache.lucene.luke.models.LukeException;
import org.apache.lucene.luke.models.tools.IndexTools;
import org.apache.lucene.luke.models.tools.IndexToolsFactory;
import org.apache.lucene.luke.models.util.IndexUtils;
import org.apache.lucene.luke.util.LoggerFactory;
import org.apache.lucene.util.NamedThreadFactory;
import org.apache.lucene.util.SuppressForbidden;

public final class ExportTermsDialogFactory
implements DialogOpener.DialogFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static ExportTermsDialogFactory instance;
    private final IndexToolsFactory indexToolsFactory = new IndexToolsFactory();
    private final Preferences prefs;
    private final IndexHandler indexHandler;
    private final JComboBox<String> fieldCombo = new JComboBox();
    private final JComboBox<String> delimiterCombo = new JComboBox();
    private final JTextField destDir = new JTextField();
    private final JLabel statusLbl = new JLabel();
    private final JLabel indicatorLbl = new JLabel();
    private final ListenerFunctions listeners = new ListenerFunctions();
    private JDialog dialog;
    private IndexTools toolsModel;
    private String selectedDelimiter;

    public static synchronized ExportTermsDialogFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new ExportTermsDialogFactory();
        }
        return instance;
    }

    private ExportTermsDialogFactory() throws IOException {
        this.prefs = PreferencesFactory.getInstance();
        this.indexHandler = IndexHandler.getInstance();
        this.indexHandler.addObserver(new Observer());
        Stream.of(Delimiter.values()).forEachOrdered(delimiterVal -> this.delimiterCombo.addItem(delimiterVal.getDescription()));
        this.delimiterCombo.setSelectedItem(Delimiter.COMMA.getDescription());
    }

    @Override
    public JDialog create(Window owner, String title, int width, int height) {
        this.dialog = new JDialog(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.add(this.content());
        this.dialog.setSize(new Dimension(width, height));
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.getContentPane().setBackground(this.prefs.getColorTheme().getBackgroundColor());
        return this.dialog;
    }

    private JPanel content() {
        JPanel panel = new JPanel(new GridLayout(5, 1));
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        panel.add(this.currentOpenIndexPanel());
        panel.add(this.fieldComboPanel());
        panel.add(this.destinationDirPanel());
        panel.add(this.delimiterComboPanel());
        panel.add(this.statusPanel());
        panel.add(this.actionButtonsPanel());
        return panel;
    }

    private JPanel currentOpenIndexPanel() {
        JPanel panel = new JPanel(new FlowLayout(3));
        panel.setBorder(BorderFactory.createEmptyBorder());
        panel.setOpaque(false);
        JLabel label = new JLabel(MessageUtils.getLocalizedMessage("export.terms.label.index_path"));
        JLabel value = new JLabel(this.indexHandler.getState().getIndexPath());
        value.setToolTipText(this.indexHandler.getState().getIndexPath());
        panel.add(label);
        panel.add(value);
        return panel;
    }

    private JPanel delimiterComboPanel() {
        JPanel panel = new JPanel(new GridLayout(2, 1));
        panel.setOpaque(false);
        panel.add(new JLabel("Select Delimiter: "));
        panel.add(this.delimiterCombo);
        return panel;
    }

    private JPanel fieldComboPanel() {
        JPanel panel = new JPanel(new GridLayout(2, 1));
        panel.setOpaque(false);
        panel.add(new JLabel(MessageUtils.getLocalizedMessage("export.terms.field")));
        panel.add(this.fieldCombo);
        return panel;
    }

    private JPanel destinationDirPanel() {
        JPanel panel = new JPanel(new GridLayout(2, 1));
        panel.setOpaque(false);
        panel.add(new JLabel(MessageUtils.getLocalizedMessage("export.terms.label.output_path")));
        JPanel inputPanel = new JPanel(new FlowLayout(3));
        inputPanel.setBorder(BorderFactory.createEmptyBorder());
        inputPanel.setOpaque(false);
        this.destDir.setText(System.getProperty("user.home"));
        this.destDir.setColumns(60);
        this.destDir.setPreferredSize(new Dimension(200, 30));
        this.destDir.setFont(StyleConstants.FONT_MONOSPACE_LARGE);
        this.destDir.setEditable(false);
        this.destDir.setBackground(Color.white);
        inputPanel.add(this.destDir);
        JButton browseBtn = new JButton(MessageUtils.getLocalizedMessage("export.terms.button.browse"));
        browseBtn.setFont(StyleConstants.FONT_BUTTON_LARGE);
        browseBtn.setMargin(new Insets(3, 0, 3, 0));
        browseBtn.addActionListener(this.listeners::browseDirectory);
        inputPanel.add(browseBtn);
        panel.add(inputPanel);
        return panel;
    }

    private JPanel actionButtonsPanel() {
        JPanel execButtons = new JPanel(new FlowLayout(4));
        execButtons.setOpaque(false);
        JButton exportBtn = new JButton(MessageUtils.getLocalizedMessage("export.terms.button.export"));
        exportBtn.setMargin(new Insets(3, 0, 3, 0));
        exportBtn.addActionListener(this.listeners::export);
        execButtons.add(exportBtn);
        JButton closeBtn = new JButton(MessageUtils.getLocalizedMessage("button.close"));
        closeBtn.setMargin(new Insets(3, 0, 3, 0));
        closeBtn.addActionListener(e -> this.dialog.dispose());
        execButtons.add(closeBtn);
        return execButtons;
    }

    private JPanel statusPanel() {
        JPanel status = new JPanel(new FlowLayout(3));
        status.setOpaque(false);
        this.indicatorLbl.setIcon(ImageUtils.createImageIcon("indicator.gif", 20, 20));
        this.indicatorLbl.setVisible(false);
        status.add(this.statusLbl);
        status.add(this.indicatorLbl);
        return status;
    }

    private static enum Delimiter {
        COMMA("Comma", ","),
        WHITESPACE("Whitespace", " "),
        TAB("Tab", "\t");

        private final String description;
        private final String separator;

        private Delimiter(String description, String separator) {
            this.description = description;
            this.separator = separator;
        }

        String getDescription() {
            return this.description;
        }

        String getSeparator() {
            return this.separator;
        }

        static String getSelectedDelimiterValue(String delimiter) {
            return Arrays.stream(Delimiter.values()).filter(e -> e.description.equals(delimiter)).findFirst().orElse(COMMA).getSeparator();
        }
    }

    private class Observer
    implements IndexObserver {
        private Observer() {
        }

        @Override
        public void openIndex(LukeState state) {
            ExportTermsDialogFactory.this.toolsModel = ExportTermsDialogFactory.this.indexToolsFactory.newInstance(state.getIndexReader(), state.useCompound(), state.keepAllCommits());
            IndexUtils.getFieldNames(state.getIndexReader()).stream().sorted().forEach(ExportTermsDialogFactory.this.fieldCombo::addItem);
        }

        @Override
        public void closeIndex() {
            ExportTermsDialogFactory.this.fieldCombo.removeAllItems();
            ExportTermsDialogFactory.this.toolsModel = null;
        }
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        @SuppressForbidden(reason="JFilechooser#getSelectedFile() returns java.io.File")
        void browseDirectory(ActionEvent e) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileSelectionMode(1);
            fileChooser.setFileHidingEnabled(false);
            int retVal = fileChooser.showOpenDialog(ExportTermsDialogFactory.this.dialog);
            if (retVal == 0) {
                File f = fileChooser.getSelectedFile();
                ExportTermsDialogFactory.this.destDir.setText(f.getAbsolutePath());
            }
        }

        void export(ActionEvent e) {
            ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("export-terms-dialog"));
            SwingWorker<Void, Void> task = new SwingWorker<Void, Void>(){
                String filename;

                @Override
                protected Void doInBackground() {
                    this.setProgress(0);
                    ExportTermsDialogFactory.this.statusLbl.setText("Exporting...");
                    ExportTermsDialogFactory.this.indicatorLbl.setVisible(true);
                    String field = (String)ExportTermsDialogFactory.this.fieldCombo.getSelectedItem();
                    ExportTermsDialogFactory.this.selectedDelimiter = Delimiter.getSelectedDelimiterValue((String)ExportTermsDialogFactory.this.delimiterCombo.getSelectedItem());
                    String directory = ExportTermsDialogFactory.this.destDir.getText();
                    try {
                        this.filename = ExportTermsDialogFactory.this.toolsModel.exportTerms(directory, field, ExportTermsDialogFactory.this.selectedDelimiter);
                    }
                    catch (LukeException e) {
                        log.error("Error while exporting terms from field " + field, (Throwable)e);
                        ExportTermsDialogFactory.this.statusLbl.setText(MessageUtils.getLocalizedMessage("export.terms.label.error", e.getMessage()));
                    }
                    catch (Exception e) {
                        log.error("Error while exporting terms from field " + field, (Throwable)e);
                        ExportTermsDialogFactory.this.statusLbl.setText(MessageUtils.getLocalizedMessage("message.error.unknown"));
                        throw e;
                    }
                    finally {
                        this.setProgress(100);
                    }
                    return null;
                }

                @Override
                protected void done() {
                    ExportTermsDialogFactory.this.indicatorLbl.setVisible(false);
                    if (this.filename != null) {
                        ExportTermsDialogFactory.this.statusLbl.setText(MessageUtils.getLocalizedMessage("export.terms.label.success", this.filename, "[term]" + ExportTermsDialogFactory.this.selectedDelimiter + "[doc frequency]"));
                    }
                }
            };
            executor.submit(task);
            executor.shutdown();
        }
    }
}

