/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.luke.app.AbstractHandler;
import org.apache.lucene.luke.app.IndexObserver;
import org.apache.lucene.luke.app.LukeState;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.models.LukeException;
import org.apache.lucene.luke.models.util.IndexUtils;
import org.apache.lucene.luke.util.LoggerFactory;

public final class IndexHandler
extends AbstractHandler<IndexObserver> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final IndexHandler instance = new IndexHandler();
    private LukeStateImpl state;

    public static IndexHandler getInstance() {
        return instance;
    }

    @Override
    protected void notifyOne(IndexObserver observer) {
        if (this.state.closed) {
            observer.closeIndex();
        } else {
            observer.openIndex(this.state);
        }
    }

    public boolean indexOpened() {
        return this.state != null && !this.state.closed;
    }

    public void open(String indexPath, String dirImpl) {
        this.open(indexPath, dirImpl, false, false, false);
    }

    public void open(String indexPath, String dirImpl, boolean readOnly, boolean useCompound, boolean keepAllCommits) {
        IndexReader reader;
        Objects.requireNonNull(indexPath);
        if (this.indexOpened()) {
            this.close();
        }
        try {
            reader = IndexUtils.openIndex(indexPath, dirImpl);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new LukeException(MessageUtils.getLocalizedMessage("openindex.message.index_path_invalid", indexPath), e);
        }
        this.state = new LukeStateImpl();
        this.state.indexPath = indexPath;
        this.state.reader = reader;
        this.state.dirImpl = dirImpl;
        this.state.readOnly = readOnly;
        this.state.useCompound = useCompound;
        this.state.keepAllCommits = keepAllCommits;
        this.notifyObservers();
    }

    public void close() {
        if (this.state == null) {
            return;
        }
        IndexUtils.close(this.state.reader);
        this.state.closed = true;
        this.notifyObservers();
    }

    public void reOpen() {
        this.close();
        this.open(this.state.getIndexPath(), this.state.getDirImpl(), this.state.readOnly(), this.state.useCompound(), this.state.keepAllCommits());
    }

    public LukeState getState() {
        return this.state;
    }

    private static class LukeStateImpl
    implements LukeState {
        private boolean closed = false;
        private String indexPath;
        private IndexReader reader;
        private String dirImpl;
        private boolean readOnly;
        private boolean useCompound;
        private boolean keepAllCommits;

        private LukeStateImpl() {
        }

        @Override
        public String getIndexPath() {
            return this.indexPath;
        }

        @Override
        public IndexReader getIndexReader() {
            return this.reader;
        }

        @Override
        public String getDirImpl() {
            return this.dirImpl;
        }

        @Override
        public boolean readOnly() {
            return this.readOnly;
        }

        @Override
        public boolean useCompound() {
            return this.useCompound;
        }

        @Override
        public boolean keepAllCommits() {
            return this.keepAllCommits;
        }
    }
}

