/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.dialog.menubar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.luke.app.IndexHandler;
import org.apache.lucene.luke.app.IndexObserver;
import org.apache.lucene.luke.app.LukeState;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.PreferencesFactory;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.ImageUtils;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.StyleConstants;
import org.apache.lucene.luke.app.desktop.util.TextAreaPrintStream;
import org.apache.lucene.luke.models.tools.IndexTools;
import org.apache.lucene.luke.models.tools.IndexToolsFactory;
import org.apache.lucene.luke.util.LoggerFactory;
import org.apache.lucene.util.NamedThreadFactory;

public final class OptimizeIndexDialogFactory
implements DialogOpener.DialogFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static OptimizeIndexDialogFactory instance;
    private final Preferences prefs;
    private final IndexToolsFactory indexToolsFactory = new IndexToolsFactory();
    private final IndexHandler indexHandler;
    private final JCheckBox expungeCB = new JCheckBox();
    private final JSpinner maxSegSpnr = new JSpinner();
    private final JLabel statusLbl = new JLabel();
    private final JLabel indicatorLbl = new JLabel();
    private final JTextArea logArea = new JTextArea();
    private final ListenerFunctions listeners = new ListenerFunctions();
    private JDialog dialog;
    private IndexTools toolsModel;

    public static synchronized OptimizeIndexDialogFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new OptimizeIndexDialogFactory();
        }
        return instance;
    }

    private OptimizeIndexDialogFactory() throws IOException {
        this.prefs = PreferencesFactory.getInstance();
        this.indexHandler = IndexHandler.getInstance();
        this.indexHandler.addObserver(new Observer());
        this.initialize();
    }

    private void initialize() {
        this.expungeCB.setText(MessageUtils.getLocalizedMessage("optimize.checkbox.expunge"));
        this.expungeCB.setOpaque(false);
        this.maxSegSpnr.setModel(new SpinnerNumberModel(1, 1, 100, 1));
        this.maxSegSpnr.setPreferredSize(new Dimension(100, 30));
        this.indicatorLbl.setIcon(ImageUtils.createImageIcon("indicator.gif", 20, 20));
        this.logArea.setEditable(false);
    }

    @Override
    public JDialog create(Window owner, String title, int width, int height) {
        this.dialog = new JDialog(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.add(this.content());
        this.dialog.setSize(new Dimension(width, height));
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.getContentPane().setBackground(this.prefs.getColorTheme().getBackgroundColor());
        return this.dialog;
    }

    private JPanel content() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        panel.add(this.controller());
        panel.add(new JSeparator(0));
        panel.add(this.logs());
        return panel;
    }

    private JPanel controller() {
        JPanel panel = new JPanel(new GridLayout(4, 1));
        panel.setOpaque(false);
        JPanel idxPath = new JPanel(new FlowLayout(3));
        idxPath.setOpaque(false);
        idxPath.add(new JLabel(MessageUtils.getLocalizedMessage("optimize.label.index_path")));
        JLabel idxPathLbl = new JLabel(this.indexHandler.getState().getIndexPath());
        idxPathLbl.setToolTipText(this.indexHandler.getState().getIndexPath());
        idxPath.add(idxPathLbl);
        panel.add(idxPath);
        JPanel expunge = new JPanel(new FlowLayout(3));
        expunge.setOpaque(false);
        expunge.add(this.expungeCB);
        panel.add(expunge);
        JPanel maxSegs = new JPanel(new FlowLayout(3));
        maxSegs.setOpaque(false);
        maxSegs.add(new JLabel(MessageUtils.getLocalizedMessage("optimize.label.max_segments")));
        maxSegs.add(this.maxSegSpnr);
        panel.add(maxSegs);
        JPanel execButtons = new JPanel(new FlowLayout(4));
        execButtons.setOpaque(false);
        JButton optimizeBtn = new JButton(FontUtils.elegantIconHtml("&#xe0ff;", MessageUtils.getLocalizedMessage("optimize.button.optimize")));
        optimizeBtn.setFont(StyleConstants.FONT_BUTTON_LARGE);
        optimizeBtn.setMargin(new Insets(3, 0, 3, 0));
        optimizeBtn.addActionListener(this.listeners::optimize);
        execButtons.add(optimizeBtn);
        JButton closeBtn = new JButton(MessageUtils.getLocalizedMessage("button.close"));
        closeBtn.setFont(StyleConstants.FONT_BUTTON_LARGE);
        closeBtn.setMargin(new Insets(3, 0, 3, 0));
        closeBtn.addActionListener(e -> this.dialog.dispose());
        execButtons.add(closeBtn);
        panel.add(execButtons);
        return panel;
    }

    private JPanel logs() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        JPanel header = new JPanel(new GridLayout(2, 1));
        header.setOpaque(false);
        header.add(new JLabel(MessageUtils.getLocalizedMessage("optimize.label.note")));
        JPanel status = new JPanel(new FlowLayout(3));
        status.setOpaque(false);
        status.add(new JLabel(MessageUtils.getLocalizedMessage("label.status")));
        this.statusLbl.setText("Idle");
        status.add(this.statusLbl);
        this.indicatorLbl.setVisible(false);
        status.add(this.indicatorLbl);
        header.add(status);
        panel.add((Component)header, "First");
        this.logArea.setText("");
        panel.add((Component)new JScrollPane(this.logArea), "Center");
        return panel;
    }

    private class Observer
    implements IndexObserver {
        private Observer() {
        }

        @Override
        public void openIndex(LukeState state) {
            OptimizeIndexDialogFactory.this.toolsModel = OptimizeIndexDialogFactory.this.indexToolsFactory.newInstance(state.getIndexReader(), state.useCompound(), state.keepAllCommits());
        }

        @Override
        public void closeIndex() {
            OptimizeIndexDialogFactory.this.toolsModel = null;
        }
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void optimize(ActionEvent e) {
            ExecutorService executor = Executors.newFixedThreadPool(1, (ThreadFactory)new NamedThreadFactory("optimize-index-dialog"));
            SwingWorker<Void, Void> task = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() {
                    this.setProgress(0);
                    OptimizeIndexDialogFactory.this.statusLbl.setText("Running...");
                    OptimizeIndexDialogFactory.this.indicatorLbl.setVisible(true);
                    try {
                        TextAreaPrintStream ps = new TextAreaPrintStream(OptimizeIndexDialogFactory.this.logArea);
                        OptimizeIndexDialogFactory.this.toolsModel.optimize(OptimizeIndexDialogFactory.this.expungeCB.isSelected(), (Integer)OptimizeIndexDialogFactory.this.maxSegSpnr.getValue(), ps);
                        ps.flush();
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                    }
                    catch (Exception e) {
                        OptimizeIndexDialogFactory.this.statusLbl.setText(MessageUtils.getLocalizedMessage("message.error.unknown"));
                        throw e;
                    }
                    finally {
                        this.setProgress(100);
                    }
                    return null;
                }

                @Override
                protected void done() {
                    OptimizeIndexDialogFactory.this.indicatorLbl.setVisible(false);
                    OptimizeIndexDialogFactory.this.statusLbl.setText("Done");
                    OptimizeIndexDialogFactory.this.indexHandler.reOpen();
                }
            };
            executor.submit(task);
            executor.shutdown();
        }
    }
}

