/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.util;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MultiBits;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.NoDeletionPolicy;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.luke.util.LoggerFactory;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.util.Bits;

public final class IndexUtils {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static IndexReader openIndex(String indexPath, final String dirImpl) throws Exception {
        Path root = FileSystems.getDefault().getPath(Objects.requireNonNull(indexPath), new String[0]);
        final ArrayList readers = new ArrayList();
        Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                Directory dir = IndexUtils.openDirectory(path, dirImpl);
                try {
                    DirectoryReader dr = DirectoryReader.open((Directory)dir);
                    readers.add(dr);
                }
                catch (IOException e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        if (readers.isEmpty()) {
            throw new RuntimeException("No valid directory at the location: " + indexPath);
        }
        log.info(String.format(Locale.ENGLISH, "IndexReaders (%d leaf readers) successfully opened. Index path=%s", readers.size(), indexPath));
        if (readers.size() == 1) {
            return (IndexReader)readers.get(0);
        }
        return new MultiReader(readers.toArray(new IndexReader[readers.size()]));
    }

    public static Directory openDirectory(String dirPath, String dirImpl) throws IOException {
        Path path = FileSystems.getDefault().getPath(Objects.requireNonNull(dirPath), new String[0]);
        Directory dir = IndexUtils.openDirectory(path, dirImpl);
        log.info(String.format(Locale.ENGLISH, "DirectoryReader successfully opened. Directory path=%s", dirPath));
        return dir;
    }

    private static Directory openDirectory(Path path, String dirImpl) throws IOException {
        FSDirectory dir;
        if (!Files.exists(Objects.requireNonNull(path), new LinkOption[0])) {
            throw new IllegalArgumentException("Index directory doesn't exist.");
        }
        if (dirImpl == null || dirImpl.equalsIgnoreCase("org.apache.lucene.store.FSDirectory")) {
            dir = FSDirectory.open((Path)path);
        } else {
            try {
                Class<?> implClazz = Class.forName(dirImpl);
                Constructor<?> constr = implClazz.getConstructor(Path.class);
                if (constr != null) {
                    dir = (Directory)constr.newInstance(path);
                } else {
                    constr = implClazz.getConstructor(Path.class, LockFactory.class);
                    dir = (Directory)constr.newInstance(path, null);
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException("Invalid directory implementation class: " + dirImpl);
            }
        }
        return dir;
    }

    public static void close(Directory dir) {
        try {
            if (dir != null) {
                dir.close();
                log.info("Directory successfully closed.");
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void close(IndexReader reader) {
        try {
            if (reader != null) {
                reader.close();
                log.info("IndexReader successfully closed.");
                if (reader instanceof DirectoryReader) {
                    Directory dir = ((DirectoryReader)reader).directory();
                    dir.close();
                    log.info("Directory successfully closed.");
                }
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static IndexWriter createWriter(Directory dir, Analyzer analyzer, boolean useCompound, boolean keepAllCommits) throws IOException {
        return IndexUtils.createWriter(Objects.requireNonNull(dir), analyzer, useCompound, keepAllCommits, null);
    }

    public static IndexWriter createWriter(Directory dir, Analyzer analyzer, boolean useCompound, boolean keepAllCommits, PrintStream ps) throws IOException {
        Objects.requireNonNull(dir);
        IndexWriterConfig config = new IndexWriterConfig((Analyzer)(analyzer == null ? new WhitespaceAnalyzer() : analyzer));
        config.setUseCompoundFile(useCompound);
        if (ps != null) {
            config.setInfoStream(ps);
        }
        if (keepAllCommits) {
            config.setIndexDeletionPolicy(NoDeletionPolicy.INSTANCE);
        } else {
            config.setIndexDeletionPolicy((IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy());
        }
        return new IndexWriter(dir, config);
    }

    public static void optimizeIndex(IndexWriter writer, boolean expunge, int maxNumSegments) throws IOException {
        Objects.requireNonNull(writer);
        if (expunge) {
            writer.forceMergeDeletes(true);
        } else {
            writer.forceMerge(maxNumSegments, true);
        }
    }

    public static CheckIndex.Status checkIndex(Directory dir, PrintStream ps) throws IOException {
        Objects.requireNonNull(dir);
        try (CheckIndex ci = new CheckIndex(dir);){
            if (ps != null) {
                ci.setInfoStream(ps);
            }
            CheckIndex.Status status = ci.checkIndex();
            return status;
        }
    }

    public static void tryRepairIndex(Directory dir, CheckIndex.Status st, PrintStream ps) throws IOException {
        Objects.requireNonNull(dir);
        Objects.requireNonNull(st);
        try (CheckIndex ci = new CheckIndex(dir);){
            if (ps != null) {
                ci.setInfoStream(ps);
            }
            ci.exorciseIndex(st);
        }
    }

    public static String getIndexFormat(final Directory dir) throws IOException {
        Objects.requireNonNull(dir);
        return (String)new SegmentInfos.FindSegmentsFile<String>(dir){

            protected String doBody(String segmentFileName) throws IOException {
                String format = "unknown";
                try (IndexInput in = dir.openInput(segmentFileName, IOContext.READ);){
                    if (1071082519 == in.readInt()) {
                        int actualVersion = CodecUtil.checkHeaderNoMagic((DataInput)in, (String)"segments", (int)7, (int)Integer.MAX_VALUE);
                        if (actualVersion == 7) {
                            format = "Lucene 7.0 or later";
                        } else if (actualVersion == 8) {
                            format = "Lucene 7.2 or later";
                        } else if (actualVersion == 9) {
                            format = "Lucene 7.4 or later";
                        } else if (actualVersion > 9) {
                            format = "Lucene 7.4 or later (UNSUPPORTED)";
                        }
                    } else {
                        format = "Lucene 6.x or prior (UNSUPPORTED)";
                    }
                }
                return format;
            }
        }.run();
    }

    public static String getCommitUserData(IndexCommit ic) throws IOException {
        Map userDataMap = Objects.requireNonNull(ic).getUserData();
        if (userDataMap != null) {
            return userDataMap.toString();
        }
        return "--";
    }

    public static Map<String, Long> countTerms(IndexReader reader, Collection<String> fields) throws IOException {
        HashMap<String, Long> res = new HashMap<String, Long>();
        for (String field : fields) {
            Terms terms;
            if (!res.containsKey(field)) {
                res.put(field, 0L);
            }
            if ((terms = MultiTerms.getTerms((IndexReader)reader, (String)field)) == null) continue;
            TermsEnum te = terms.iterator();
            while (te.next() != null) {
                res.put(field, (Long)res.get(field) + 1L);
            }
        }
        return res;
    }

    public static Bits getLiveDocs(IndexReader reader) {
        if (reader instanceof LeafReader) {
            return ((LeafReader)reader).getLiveDocs();
        }
        return MultiBits.getLiveDocs((IndexReader)reader);
    }

    public static FieldInfos getFieldInfos(IndexReader reader) {
        if (reader instanceof LeafReader) {
            return ((LeafReader)reader).getFieldInfos();
        }
        return FieldInfos.getMergedFieldInfos((IndexReader)reader);
    }

    public static FieldInfo getFieldInfo(IndexReader reader, String fieldName) {
        return IndexUtils.getFieldInfos(reader).fieldInfo(fieldName);
    }

    public static Collection<String> getFieldNames(IndexReader reader) {
        return StreamSupport.stream(IndexUtils.getFieldInfos(reader).spliterator(), false).map(f -> f.name).collect(Collectors.toList());
    }

    public static Terms getTerms(IndexReader reader, String field) throws IOException {
        if (reader instanceof LeafReader) {
            return ((LeafReader)reader).terms(field);
        }
        return MultiTerms.getTerms((IndexReader)reader, (String)field);
    }

    public static BinaryDocValues getBinaryDocValues(IndexReader reader, String field) throws IOException {
        if (reader instanceof LeafReader) {
            return ((LeafReader)reader).getBinaryDocValues(field);
        }
        return MultiDocValues.getBinaryValues((IndexReader)reader, (String)field);
    }

    public static NumericDocValues getNumericDocValues(IndexReader reader, String field) throws IOException {
        if (reader instanceof LeafReader) {
            return ((LeafReader)reader).getNumericDocValues(field);
        }
        return MultiDocValues.getNumericValues((IndexReader)reader, (String)field);
    }

    public static SortedNumericDocValues getSortedNumericDocValues(IndexReader reader, String field) throws IOException {
        if (reader instanceof LeafReader) {
            return ((LeafReader)reader).getSortedNumericDocValues(field);
        }
        return MultiDocValues.getSortedNumericValues((IndexReader)reader, (String)field);
    }

    public static SortedDocValues getSortedDocValues(IndexReader reader, String field) throws IOException {
        if (reader instanceof LeafReader) {
            return ((LeafReader)reader).getSortedDocValues(field);
        }
        return MultiDocValues.getSortedValues((IndexReader)reader, (String)field);
    }

    public static SortedSetDocValues getSortedSetDocvalues(IndexReader reader, String field) throws IOException {
        if (reader instanceof LeafReader) {
            return ((LeafReader)reader).getSortedSetDocValues(field);
        }
        return MultiDocValues.getSortedSetValues((IndexReader)reader, (String)field);
    }

    private IndexUtils() {
    }
}

