/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.documents;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.luke.util.BytesRefUtils;

public final class TermVectorEntry {
    private final String termText;
    private final long freq;
    private final List<TermVectorPosition> positions;

    static TermVectorEntry of(TermsEnum te) throws IOException {
        Objects.requireNonNull(te);
        String termText = BytesRefUtils.decode(te.term());
        ArrayList<TermVectorPosition> tvPositions = new ArrayList<TermVectorPosition>();
        PostingsEnum pe = te.postings(null, 56);
        pe.nextDoc();
        int freq = pe.freq();
        for (int i = 0; i < freq; ++i) {
            int pos = pe.nextPosition();
            if (pos < 0) continue;
            TermVectorPosition tvPos = TermVectorPosition.of(pos, pe);
            tvPositions.add(tvPos);
        }
        return new TermVectorEntry(termText, te.totalTermFreq(), tvPositions);
    }

    private TermVectorEntry(String termText, long freq, List<TermVectorPosition> positions) {
        this.termText = termText;
        this.freq = freq;
        this.positions = positions;
    }

    public String getTermText() {
        return this.termText;
    }

    public long getFreq() {
        return this.freq;
    }

    public List<TermVectorPosition> getPositions() {
        return this.positions;
    }

    public String toString() {
        String positionsStr = this.positions.stream().map(TermVectorPosition::toString).collect(Collectors.joining(","));
        return "TermVectorEntry{termText='" + this.termText + '\'' + ", freq=" + this.freq + ", positions=" + positionsStr + '}';
    }

    public static final class TermVectorPosition {
        private final int position;
        private final int startOffset;
        private final int endOffset;

        static TermVectorPosition of(int pos, PostingsEnum pe) throws IOException {
            Objects.requireNonNull(pe);
            int sOffset = pe.startOffset();
            int eOffset = pe.endOffset();
            if (sOffset >= 0 && eOffset >= 0) {
                return new TermVectorPosition(pos, sOffset, eOffset);
            }
            return new TermVectorPosition(pos);
        }

        public int getPosition() {
            return this.position;
        }

        public OptionalInt getStartOffset() {
            return this.startOffset >= 0 ? OptionalInt.of(this.startOffset) : OptionalInt.empty();
        }

        public OptionalInt getEndOffset() {
            return this.endOffset >= 0 ? OptionalInt.of(this.endOffset) : OptionalInt.empty();
        }

        public String toString() {
            return "TermVectorPosition{position=" + this.position + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + '}';
        }

        private TermVectorPosition(int position) {
            this(position, -1, -1);
        }

        private TermVectorPosition(int position, int startOffset, int endOffset) {
            this.position = position;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }
    }
}

