/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.commits;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.luke.models.LukeException;
import org.apache.lucene.luke.models.LukeModel;
import org.apache.lucene.luke.models.commits.Commit;
import org.apache.lucene.luke.models.commits.Commits;
import org.apache.lucene.luke.models.commits.File;
import org.apache.lucene.luke.models.commits.Segment;
import org.apache.lucene.luke.util.LoggerFactory;
import org.apache.lucene.store.Directory;

public final class CommitsImpl
extends LukeModel
implements Commits {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String indexPath;
    private final Map<Long, IndexCommit> commitMap;

    public CommitsImpl(Directory dir, String indexPath) {
        super(dir);
        this.indexPath = indexPath;
        this.commitMap = this.initCommitMap();
    }

    public CommitsImpl(DirectoryReader reader, String indexPath) {
        super(reader.directory());
        this.indexPath = indexPath;
        this.commitMap = this.initCommitMap();
    }

    private Map<Long, IndexCommit> initCommitMap() {
        try {
            List indexCommits = DirectoryReader.listCommits((Directory)this.dir);
            TreeMap<Long, IndexCommit> map = new TreeMap<Long, IndexCommit>();
            for (IndexCommit ic : indexCommits) {
                map.put(ic.getGeneration(), ic);
            }
            return map;
        }
        catch (IOException e) {
            throw new LukeException("Failed to get commits list.", e);
        }
    }

    @Override
    public List<Commit> listCommits() throws LukeException {
        List<Commit> commits = this.getCommitMap().values().stream().map(Commit::of).collect(Collectors.toList());
        Collections.reverse(commits);
        return commits;
    }

    @Override
    public Optional<Commit> getCommit(long commitGen) throws LukeException {
        IndexCommit ic = this.getCommitMap().get(commitGen);
        if (ic == null) {
            String msg = String.format(Locale.ENGLISH, "Commit generation %d not exists.", commitGen);
            log.warn(msg);
            return Optional.empty();
        }
        return Optional.of(Commit.of(ic));
    }

    @Override
    public List<File> getFiles(long commitGen) throws LukeException {
        IndexCommit ic = this.getCommitMap().get(commitGen);
        if (ic == null) {
            String msg = String.format(Locale.ENGLISH, "Commit generation %d not exists.", commitGen);
            log.warn(msg);
            return Collections.emptyList();
        }
        try {
            return ic.getFileNames().stream().map(name -> File.of(this.indexPath, name)).sorted(Comparator.comparing(File::getFileName)).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new LukeException(String.format(Locale.ENGLISH, "Failed to load files for commit generation %d", commitGen), e);
        }
    }

    @Override
    public List<Segment> getSegments(long commitGen) throws LukeException {
        try {
            SegmentInfos infos = this.findSegmentInfos(commitGen);
            if (infos == null) {
                return Collections.emptyList();
            }
            return infos.asList().stream().map(Segment::of).sorted(Comparator.comparing(Segment::getName)).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new LukeException(String.format(Locale.ENGLISH, "Failed to load segment infos for commit generation %d", commitGen), e);
        }
    }

    @Override
    public Map<String, String> getSegmentAttributes(long commitGen, String name) throws LukeException {
        try {
            SegmentInfos infos = this.findSegmentInfos(commitGen);
            if (infos == null) {
                return Collections.emptyMap();
            }
            return infos.asList().stream().filter(seg -> seg.info.name.equals(name)).findAny().map(seg -> seg.info.getAttributes()).orElse(Collections.emptyMap());
        }
        catch (IOException e) {
            throw new LukeException(String.format(Locale.ENGLISH, "Failed to load segment infos for commit generation %d", commitGen), e);
        }
    }

    @Override
    public Map<String, String> getSegmentDiagnostics(long commitGen, String name) throws LukeException {
        try {
            SegmentInfos infos = this.findSegmentInfos(commitGen);
            if (infos == null) {
                return Collections.emptyMap();
            }
            return infos.asList().stream().filter(seg -> seg.info.name.equals(name)).findAny().map(seg -> seg.info.getDiagnostics()).orElse(Collections.emptyMap());
        }
        catch (IOException e) {
            throw new LukeException(String.format(Locale.ENGLISH, "Failed to load segment infos for commit generation %d", commitGen), e);
        }
    }

    @Override
    public Optional<Codec> getSegmentCodec(long commitGen, String name) throws LukeException {
        try {
            SegmentInfos infos = this.findSegmentInfos(commitGen);
            if (infos == null) {
                return Optional.empty();
            }
            return infos.asList().stream().filter(seg -> seg.info.name.equals(name)).findAny().map(seg -> seg.info.getCodec());
        }
        catch (IOException e) {
            throw new LukeException(String.format(Locale.ENGLISH, "Failed to load segment infos for commit generation %d", commitGen), e);
        }
    }

    private Map<Long, IndexCommit> getCommitMap() throws LukeException {
        if (this.dir == null) {
            return Collections.emptyMap();
        }
        return new TreeMap<Long, IndexCommit>(this.commitMap);
    }

    private SegmentInfos findSegmentInfos(long commitGen) throws LukeException, IOException {
        IndexCommit ic = this.getCommitMap().get(commitGen);
        if (ic == null) {
            return null;
        }
        String segmentFile = ic.getSegmentsFileName();
        return SegmentInfos.readCommit((Directory)this.dir, (String)segmentFile);
    }

    static String toDisplaySize(long size) {
        if (size < 1024L) {
            return String.valueOf(size) + " B";
        }
        if (size < 0x100000L) {
            return String.valueOf(size / 1024L) + " KB";
        }
        return String.valueOf(size / 0x100000L) + " MB";
    }
}

