/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class MessageUtils {
    public static final String MESSAGE_BUNDLE_BASENAME = "org/apache/lucene/luke/app/desktop/messages/messages";
    private static ResourceBundle.Control UTF8_RESOURCEBUNDLE_CONTROL = new ResourceBundle.Control(){

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            try (InputStream is = loader.getResourceAsStream(resourceName);){
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(new InputStreamReader(is, StandardCharsets.UTF_8));
                return propertyResourceBundle;
            }
        }
    };
    private static ResourceBundle bundle = ResourceBundle.getBundle("org/apache/lucene/luke/app/desktop/messages/messages", Locale.ENGLISH, UTF8_RESOURCEBUNDLE_CONTROL);

    public static String getLocalizedMessage(String key) {
        return bundle.getString(key);
    }

    public static String getLocalizedMessage(String key, Object ... args) {
        String pattern = bundle.getString(key);
        return new MessageFormat(pattern, Locale.ENGLISH).format(args);
    }

    private MessageUtils() {
    }
}

