/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;

abstract class DocumentBatch
implements Closeable,
Supplier<LeafReader> {
    DocumentBatch() {
    }

    public static DocumentBatch of(Analyzer analyzer, Document doc) {
        return new SingletonDocumentBatch(analyzer, doc);
    }

    public static DocumentBatch of(Analyzer analyzer, Document ... docs) {
        return new MultiDocumentBatch(analyzer, docs);
    }

    private static class SingletonDocumentBatch
    extends DocumentBatch {
        private final LeafReader reader;

        private SingletonDocumentBatch(Analyzer analyzer, Document doc) {
            MemoryIndex memoryindex = new MemoryIndex(true, true);
            for (IndexableField field : doc) {
                memoryindex.addField(field, analyzer);
            }
            memoryindex.freeze();
            this.reader = (LeafReader)memoryindex.createSearcher().getIndexReader();
        }

        @Override
        public LeafReader get() {
            return this.reader;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    private static class MultiDocumentBatch
    extends DocumentBatch {
        private final Directory directory = new ByteBuffersDirectory();
        private final LeafReader reader;

        MultiDocumentBatch(Analyzer analyzer, Document ... docs) {
            IndexWriterConfig iwc = new IndexWriterConfig(analyzer);
            try (IndexWriter writer = new IndexWriter(this.directory, iwc);){
                this.reader = this.build(writer, docs);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public LeafReader get() {
            return this.reader;
        }

        private LeafReader build(IndexWriter writer, Document ... docs) throws IOException {
            writer.addDocuments(Arrays.asList(docs));
            writer.commit();
            writer.forceMerge(1);
            LeafReader reader = ((LeafReaderContext)DirectoryReader.open((Directory)this.directory).leaves().get(0)).reader();
            assert (reader != null);
            return reader;
        }

        @Override
        public void close() throws IOException {
            IOUtils.close((Closeable[])new Closeable[]{this.reader, this.directory});
        }
    }
}

