/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.shape;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.locationtech.spatial4j.TestLog;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.RandomizedShapeTest;
import org.locationtech.spatial4j.shape.RectIntersectionTestHelper;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;
import org.locationtech.spatial4j.shape.SpatialRelation;
import org.locationtech.spatial4j.shape.impl.RectangleImpl;

public class ShapeCollectionTest
extends RandomizedShapeTest {
    public static final String WORLD180 = ShapeCollectionTest.getLonRangeString(SpatialContext.GEO.getWorldBounds());
    @Rule
    public final TestLog testLog = TestLog.instance;

    protected static String getLonRangeString(Rectangle bbox) {
        return bbox.getMinX() + " " + bbox.getMaxX();
    }

    @Test
    public void testBbox() {
        this.validateWorld(-180.0, 180.0, -180.0, 180.0);
        this.validateWorld(-180.0, 0.0, 0.0, 180.0);
        this.validateWorld(-90.0, 90.0, 90.0, -90.0);
    }

    @Test
    public void testBboxNotWorldWrap() {
        this.ctx = SpatialContext.GEO;
        Rectangle r1 = this.ctx.makeRectangle(-92.0, 90.0, -10.0, 10.0);
        Rectangle r2 = this.ctx.makeRectangle(130.0, 172.0, -10.0, 10.0);
        Rectangle r3 = this.ctx.makeRectangle(172.0, -60.0, -10.0, 10.0);
        ShapeCollection s = new ShapeCollection(Arrays.asList(r1, r2, r3), this.ctx);
        Assert.assertEquals((Object)"130.0 90.0", (Object)ShapeCollectionTest.getLonRangeString(s.getBoundingBox()));
    }

    private void validateWorld(double r1MinX, double r1MaxX, double r2MinX, double r2MaxX) {
        this.ctx = SpatialContext.GEO;
        Rectangle r1 = this.ctx.makeRectangle(r1MinX, r1MaxX, -10.0, 10.0);
        Rectangle r2 = this.ctx.makeRectangle(r2MinX, r2MaxX, -10.0, 10.0);
        ShapeCollection s = new ShapeCollection(Arrays.asList(r1, r2), this.ctx);
        Assert.assertEquals((Object)WORLD180, (Object)ShapeCollectionTest.getLonRangeString(s.getBoundingBox()));
        s = new ShapeCollection(Arrays.asList(r2, r1), this.ctx);
        Assert.assertEquals((Object)WORLD180, (Object)ShapeCollectionTest.getLonRangeString(s.getBoundingBox()));
    }

    @Test
    public void testRectIntersect() {
        SpatialContext ctx = new SpatialContextFactory(){
            {
                this.geo = false;
                this.worldBounds = new RectangleImpl(-100.0, 100.0, -50.0, 50.0, null);
            }
        }.newSpatialContext();
        new ShapeCollectionRectIntersectionTestHelper(ctx).testRelateWithRectangle();
    }

    @Test
    public void testGeoRectIntersect() {
        this.ctx = SpatialContext.GEO;
        new ShapeCollectionRectIntersectionTestHelper(this.ctx).testRelateWithRectangle();
    }

    private class ShapeCollectionRectIntersectionTestHelper
    extends RectIntersectionTestHelper<ShapeCollection> {
        private ShapeCollectionRectIntersectionTestHelper(SpatialContext ctx) {
            super(ctx);
        }

        @Override
        protected ShapeCollection generateRandomShape(Point nearP) {
            TestLog cfr_ignored_0 = ShapeCollectionTest.this.testLog;
            TestLog.log("Break on nearP.toString(): {}", nearP);
            ArrayList<Rectangle> shapes = new ArrayList<Rectangle>();
            int count = ShapeCollectionRectIntersectionTestHelper.randomIntBetween((int)1, (int)4);
            for (int i = 0; i < count; ++i) {
                shapes.add(this.randomRectangle((Point)(i < 2 ? nearP : null)));
            }
            ShapeCollection shapeCollection = new ShapeCollection(shapes, this.ctx);
            Rectangle msBbox = shapeCollection.getBoundingBox();
            if (shapes.size() == 1) {
                Assert.assertEquals(shapes.get(0), (Object)msBbox.getBoundingBox());
            } else {
                for (Rectangle shape : shapes) {
                    this.assertRelation("bbox contains shape", SpatialRelation.CONTAINS, (Shape)msBbox, (Shape)shape);
                }
                if (this.ctx.isGeo() && msBbox.getMinX() == -180.0 && msBbox.getMaxX() == 180.0) {
                    int lonTest = ShapeCollectionRectIntersectionTestHelper.randomIntBetween((int)-180, (int)180);
                    boolean valid = false;
                    for (Rectangle shape : shapes) {
                        if (!shape.relateXRange((double)lonTest, (double)lonTest).intersects()) continue;
                        valid = true;
                        break;
                    }
                    if (!valid) {
                        Assert.fail((String)("ShapeCollection bbox world-wrap doesn't contain " + lonTest + " for shapes: " + shapes));
                    }
                }
            }
            return shapeCollection;
        }

        @Override
        protected Point randomPointInEmptyShape(ShapeCollection shape) {
            Rectangle r = (Rectangle)shape.getShapes().get(0);
            return this.randomPointIn(r);
        }
    }
}

