/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.DatelineRule;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.locationtech.spatial4j.exception.InvalidShapeException;
import org.locationtech.spatial4j.io.jts.JtsWKTReaderShapeParser;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;

public class JtsWKTReaderShapeParserTest
extends RandomizedTest {
    final SpatialContext ctx;

    public JtsWKTReaderShapeParserTest() {
        JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
        factory.datelineRule = DatelineRule.ccwRect;
        factory.readers.clear();
        factory.readers.add(JtsWKTReaderShapeParser.class);
        this.ctx = factory.newSpatialContext();
    }

    @Test
    public void wktGeoPt() throws IOException {
        Shape s = this.read("Point(-160 30)");
        Assert.assertEquals((Object)this.ctx.makePoint(-160.0, 30.0), (Object)s);
    }

    private Shape read(String value) {
        return this.ctx.getFormats().read(value);
    }

    @Test
    public void wktGeoRect() throws IOException {
        Shape sNoDL = this.read("Polygon((-170 30, -170 15,  160 15,  160 30, -170 30))");
        Rectangle expectedNoDL = this.ctx.makeRectangle(-170.0, 160.0, 15.0, 30.0);
        Assert.assertTrue((!expectedNoDL.getCrossesDateLine() ? 1 : 0) != 0);
        Assert.assertEquals((Object)expectedNoDL, (Object)sNoDL);
        Shape sYesDL = this.read("Polygon(( 160 30,  160 15, -170 15, -170 30,  160 30))");
        Rectangle expectedYesDL = this.ctx.makeRectangle(160.0, -170.0, 15.0, 30.0);
        Assert.assertTrue((boolean)expectedYesDL.getCrossesDateLine());
        Assert.assertEquals((Object)expectedYesDL, (Object)sYesDL);
    }

    @Test
    public void testWrapTopologyException() {
        try {
            this.read("POLYGON((0 0, 10 0, 10 20))");
            Assert.fail();
        }
        catch (InvalidShapeException invalidShapeException) {
            // empty catch block
        }
        try {
            this.read("POLYGON((0 0, 10 0, 10 20, 5 -5, 0 20, 0 0))");
            Assert.fail();
        }
        catch (InvalidShapeException invalidShapeException) {
            // empty catch block
        }
    }
}

