/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io;

import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.util.GeometricShapeFactory;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.locationtech.spatial4j.io.BinaryCodecTest;
import org.locationtech.spatial4j.shape.Shape;

public class JtsBinaryCodecTest
extends BinaryCodecTest {
    @Override
    public SpatialContext initContext() {
        JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
        factory.precisionModel = new PrecisionModel(PrecisionModel.FLOATING_SINGLE);
        return factory.newSpatialContext();
    }

    @Test
    public void testPoly() {
        JtsSpatialContext ctx = (JtsSpatialContext)this.ctx;
        ctx.makeShape(this.randomGeometry(JtsBinaryCodecTest.randomIntBetween((int)3, (int)20)), false, false);
    }

    @Override
    protected Shape randomShape() {
        if (JtsBinaryCodecTest.randomInt((int)3) == 0) {
            JtsSpatialContext ctx = (JtsSpatialContext)this.ctx;
            return ctx.makeShape(this.randomGeometry(JtsBinaryCodecTest.randomIntBetween((int)3, (int)20)), false, false);
        }
        return super.randomShape();
    }

    Geometry randomGeometry(int points) {
        JtsSpatialContext ctx = (JtsSpatialContext)this.ctx;
        GeometricShapeFactory gsf = new GeometricShapeFactory(ctx.getGeometryFactory());
        gsf.setCentre(new Coordinate(0.0, 0.0));
        gsf.setSize(180.0);
        gsf.setNumPoints(points);
        return gsf.createCircle();
    }
}

