/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.util.Objects;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.geo.ComponentTree;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.XYEncodingUtils;
import org.apache.lucene.geo.XYRectangle;
import org.apache.lucene.index.PointValues;

public class XYRectangle2D
implements Component2D {
    private final double minX;
    private final double maxX;
    private final double minY;
    private final double maxY;

    protected XYRectangle2D(double minX, double maxX, double minY, double maxY) {
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public boolean contains(double x, double y) {
        return Component2D.containsPoint((double)x, (double)y, (double)this.minX, (double)this.maxX, (double)this.minY, (double)this.maxY);
    }

    public PointValues.Relation relate(double minX, double maxX, double minY, double maxY) {
        if (Component2D.disjoint((double)this.minX, (double)this.maxX, (double)this.minY, (double)this.maxY, (double)minX, (double)maxX, (double)minY, (double)maxY)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        if (Component2D.within((double)minX, (double)maxX, (double)minY, (double)maxY, (double)this.minX, (double)this.maxX, (double)this.minY, (double)this.maxY)) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        return PointValues.Relation.CELL_CROSSES_QUERY;
    }

    public PointValues.Relation relateTriangle(double minX, double maxX, double minY, double maxY, double ax, double ay, double bx, double by, double cx, double cy) {
        if (Component2D.disjoint((double)this.minX, (double)this.maxX, (double)this.minY, (double)this.maxY, (double)minX, (double)maxX, (double)minY, (double)maxY)) {
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }
        int edgesContain = this.numberOfCorners(ax, ay, bx, by, cx, cy);
        if (edgesContain == 3) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
        if (edgesContain != 0) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        if (Component2D.pointInTriangle((double)minX, (double)maxX, (double)minY, (double)maxY, (double)this.minX, (double)this.minY, (double)ax, (double)ay, (double)bx, (double)by, (double)cx, (double)cy) || this.edgesIntersect(ax, ay, bx, by) || this.edgesIntersect(bx, by, cx, cy) || this.edgesIntersect(cx, cy, ax, ay)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    public Component2D.WithinRelation withinTriangle(double minX, double maxX, double minY, double maxY, double ax, double ay, boolean ab, double bx, double by, boolean bc, double cx, double cy, boolean ca) {
        if (ax == bx && ay == by || ax == cx && ay == cy || bx == cx && by == cy) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (Component2D.disjoint((double)this.minX, (double)this.maxX, (double)this.minY, (double)this.maxY, (double)minX, (double)maxX, (double)minY, (double)maxY)) {
            return Component2D.WithinRelation.DISJOINT;
        }
        if (this.contains(ax, ay) || this.contains(bx, by) || this.contains(cx, cy)) {
            return Component2D.WithinRelation.NOTWITHIN;
        }
        Component2D.WithinRelation relation = Component2D.WithinRelation.DISJOINT;
        if (this.edgesIntersect(ax, ay, bx, by)) {
            if (ab) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.edgesIntersect(bx, by, cx, cy)) {
            if (bc) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (this.edgesIntersect(cx, cy, ax, ay)) {
            if (ca) {
                return Component2D.WithinRelation.NOTWITHIN;
            }
            relation = Component2D.WithinRelation.CANDIDATE;
        }
        if (relation == Component2D.WithinRelation.CANDIDATE) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        if (Component2D.pointInTriangle((double)minX, (double)maxX, (double)minY, (double)maxY, (double)this.minX, (double)this.minY, (double)ax, (double)ay, (double)bx, (double)by, (double)cx, (double)cy)) {
            return Component2D.WithinRelation.CANDIDATE;
        }
        return relation;
    }

    private boolean edgesIntersect(double ax, double ay, double bx, double by) {
        if (ax == bx && ay == by) {
            return false;
        }
        if (Math.max(ax, bx) < this.minX || Math.min(ax, bx) > this.maxX || Math.min(ay, by) > this.maxY || Math.max(ay, by) < this.minY) {
            return false;
        }
        if (GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.minX, (double)this.maxY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.maxX, (double)this.maxY) <= 0 && GeoUtils.orient((double)this.minX, (double)this.maxY, (double)this.maxX, (double)this.maxY, (double)ax, (double)ay) * GeoUtils.orient((double)this.minX, (double)this.maxY, (double)this.maxX, (double)this.maxY, (double)bx, (double)by) <= 0) {
            return true;
        }
        if (GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.maxX, (double)this.maxY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.maxX, (double)this.minY) <= 0 && GeoUtils.orient((double)this.maxX, (double)this.maxY, (double)this.maxX, (double)this.minY, (double)ax, (double)ay) * GeoUtils.orient((double)this.maxX, (double)this.maxY, (double)this.maxX, (double)this.minY, (double)bx, (double)by) <= 0) {
            return true;
        }
        if (GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.maxX, (double)this.minY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.minX, (double)this.minY) <= 0 && GeoUtils.orient((double)this.maxX, (double)this.minY, (double)this.minX, (double)this.minY, (double)ax, (double)ay) * GeoUtils.orient((double)this.maxX, (double)this.minY, (double)this.minX, (double)this.minY, (double)bx, (double)by) <= 0) {
            return true;
        }
        return GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.minX, (double)this.minY) * GeoUtils.orient((double)ax, (double)ay, (double)bx, (double)by, (double)this.minX, (double)this.maxY) <= 0 && GeoUtils.orient((double)this.minX, (double)this.minY, (double)this.minX, (double)this.maxY, (double)ax, (double)ay) * GeoUtils.orient((double)this.minX, (double)this.minY, (double)this.minX, (double)this.maxY, (double)bx, (double)by) <= 0;
    }

    private int numberOfCorners(double ax, double ay, double bx, double by, double cx, double cy) {
        int containsCount = 0;
        if (this.contains(ax, ay)) {
            ++containsCount;
        }
        if (this.contains(bx, by)) {
            ++containsCount;
        }
        if (this.contains(cx, cy)) {
            ++containsCount;
        }
        return containsCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XYRectangle2D)) {
            return false;
        }
        XYRectangle2D that = (XYRectangle2D)o;
        return this.minX == that.minX && this.maxX == that.maxX && this.minY == that.minY && this.maxY == that.maxY;
    }

    public int hashCode() {
        int result = Objects.hash(this.minX, this.maxX, this.minY, this.maxY);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XYRectangle(x=");
        sb.append(this.minX);
        sb.append(" TO ");
        sb.append(this.maxX);
        sb.append(" y=");
        sb.append(this.minY);
        sb.append(" TO ");
        sb.append(this.maxY);
        sb.append(")");
        return sb.toString();
    }

    public static Component2D create(XYRectangle ... rectangles) {
        Component2D[] components = new XYRectangle2D[rectangles.length];
        for (int i = 0; i < components.length; ++i) {
            components[i] = new XYRectangle2D(XYEncodingUtils.decode(XYEncodingUtils.encode(rectangles[i].minX)), XYEncodingUtils.decode(XYEncodingUtils.encode(rectangles[i].maxX)), XYEncodingUtils.decode(XYEncodingUtils.encode(rectangles[i].minY)), XYEncodingUtils.decode(XYEncodingUtils.encode(rectangles[i].maxY)));
        }
        return ComponentTree.create((Component2D[])components);
    }
}

