/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import org.locationtech.spatial4j.io.ShapeWriter;
import org.locationtech.spatial4j.shape.Shape;

public class JacksonShapeWriter
implements ShapeWriter {
    final ObjectMapper mapper;

    public JacksonShapeWriter(ObjectMapper m) {
        this.mapper = m;
    }

    public String getFormatName() {
        return this.getClass().getSimpleName();
    }

    public void write(Writer output, Shape shape) throws IOException {
        output.write(this.toString(shape));
    }

    public String toString(Shape shape) {
        try {
            return this.mapper.writeValueAsString((Object)shape);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

