/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.dialog.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.PreferencesFactory;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.search.Explanation;

public final class ExplainDialogFactory
implements DialogOpener.DialogFactory {
    private static ExplainDialogFactory instance;
    private final Preferences prefs = PreferencesFactory.getInstance();
    private JDialog dialog;
    private int docid = -1;
    private Explanation explanation;

    public static synchronized ExplainDialogFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new ExplainDialogFactory();
        }
        return instance;
    }

    private ExplainDialogFactory() throws IOException {
    }

    public void setDocid(int docid) {
        this.docid = docid;
    }

    public void setExplanation(Explanation explanation) {
        this.explanation = explanation;
    }

    @Override
    public JDialog create(Window owner, String title, int width, int height) {
        if (this.docid < 0 || Objects.isNull(this.explanation)) {
            throw new IllegalStateException("docid and/or explanation is not set.");
        }
        this.dialog = new JDialog(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.add(this.content());
        this.dialog.setSize(new Dimension(width, height));
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.getContentPane().setBackground(this.prefs.getColorTheme().getBackgroundColor());
        return this.dialog;
    }

    private JPanel content() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JPanel header = new JPanel(new FlowLayout(3, 5, 10));
        header.setOpaque(false);
        header.add(new JLabel(MessageUtils.getLocalizedMessage("search.explanation.description")));
        header.add(new JLabel(String.valueOf(this.docid)));
        panel.add((Component)header, "First");
        JPanel center = new JPanel(new GridLayout(1, 1));
        center.setOpaque(false);
        center.add(new JScrollPane(this.createExplanationTree()));
        panel.add((Component)center, "Center");
        JPanel footer = new JPanel(new FlowLayout(4, 5, 5));
        footer.setOpaque(false);
        JButton copyBtn = new JButton(FontUtils.elegantIconHtml("&#xe0e6;", MessageUtils.getLocalizedMessage("button.copy")));
        copyBtn.setMargin(new Insets(3, 3, 3, 3));
        copyBtn.addActionListener(e -> {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection selection = new StringSelection(this.explanationToString());
            clipboard.setContents(selection, null);
        });
        footer.add(copyBtn);
        JButton closeBtn = new JButton(MessageUtils.getLocalizedMessage("button.close"));
        closeBtn.setMargin(new Insets(3, 3, 3, 3));
        closeBtn.addActionListener(e -> this.dialog.dispose());
        footer.add(closeBtn);
        panel.add((Component)footer, "Last");
        return panel;
    }

    private JTree createExplanationTree() {
        DefaultMutableTreeNode top = this.createNode(this.explanation);
        this.traverse(top, this.explanation.getDetails());
        JTree tree = new JTree(top);
        tree.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
        tree.setCellRenderer(renderer);
        for (int row = 0; row < tree.getRowCount(); ++row) {
            tree.expandRow(row);
        }
        return tree;
    }

    private void traverse(DefaultMutableTreeNode parent, Explanation[] explanations) {
        for (Explanation explanation : explanations) {
            DefaultMutableTreeNode node = this.createNode(explanation);
            parent.add(node);
            this.traverse(node, explanation.getDetails());
        }
    }

    private DefaultMutableTreeNode createNode(Explanation explanation) {
        return new DefaultMutableTreeNode(this.format(explanation));
    }

    private String explanationToString() {
        StringBuilder sb = new StringBuilder(this.format(this.explanation));
        sb.append(System.lineSeparator());
        this.traverseToCopy(sb, 1, this.explanation.getDetails());
        return sb.toString();
    }

    private void traverseToCopy(StringBuilder sb, int depth, Explanation[] explanations) {
        for (Explanation explanation : explanations) {
            IntStream.range(0, depth).forEach(i -> sb.append("  "));
            sb.append(this.format(explanation));
            sb.append("\n");
            this.traverseToCopy(sb, depth + 1, explanation.getDetails());
        }
    }

    private String format(Explanation explanation) {
        return explanation.getValue() + " " + explanation.getDescription();
    }
}

